import { ClusteringModel, MiningSchema } from "../../model/pmml4_4";
import { LOCAL_TRANSFORMATIONS } from "./LocalTransformations";
import { MINING_SCHEMA } from "./MiningSchema";
import { MODEL_EXPLANATION } from "./ModelExplanation";
import { MODEL_STATS } from "./ModelStats";
import { MODEL_VERIFICATION } from "./ModelVerification";
import { OUTPUT } from "./Output";
export const CLUSTERING_MODEL = `
elements.elements[(name = "ClusteringModel")] ~> $map(function($v, $i) {
  $merge([
    $clusteringModelFactory(),
    $v.attributes,
    {
      "_type": $v.name
    },
    {
      ${MINING_SCHEMA}, 
      ${OUTPUT},
      ${MODEL_STATS},
      ${MODEL_EXPLANATION},
      ${MODEL_VERIFICATION},
      ${LOCAL_TRANSFORMATIONS}
    }
  ])
})`;
export function clusteringModelFactory() {
    return new ClusteringModel({
        MiningSchema: new MiningSchema({ MiningField: [] }),
        ComparisonMeasure: { kind: "distance" },
        ClusteringField: [],
        Cluster: [],
        functionName: "regression",
        modelClass: "centerBased",
        numberOfClusters: 0,
    });
}
//# sourceMappingURL=ClusteringModel.js.map