import { BayesianNetworkModel, MiningSchema } from "../../model/pmml4_4";
import { LOCAL_TRANSFORMATIONS } from "./LocalTransformations";
import { MINING_SCHEMA } from "./MiningSchema";
import { MODEL_EXPLANATION } from "./ModelExplanation";
import { MODEL_STATS } from "./ModelStats";
import { MODEL_VERIFICATION } from "./ModelVerification";
import { OUTPUT } from "./Output";
export const BAYESIAN_NETWORK_MODEL = `
elements.elements[(name = "BayesianNetworkModel")] ~> $map(function($v, $i) {
  $merge([
    $bayesianNetworkModelFactory(),
    $v.attributes,
    {
      "_type": $v.name
    },
    {
      ${MINING_SCHEMA}, 
      ${OUTPUT},
      ${MODEL_STATS},
      ${MODEL_EXPLANATION},
      ${MODEL_VERIFICATION},
      ${LOCAL_TRANSFORMATIONS}
    }
  ])
})`;
export function bayesianNetworkModelFactory() {
    return new BayesianNetworkModel({
        MiningSchema: new MiningSchema({ MiningField: [] }),
        BayesianNetworkNodes: {},
        functionName: "regression",
    });
}
//# sourceMappingURL=BayesianNetworkModel.js.map