import { AssociationModel, MiningSchema } from "../../model/pmml4_4";
import { LOCAL_TRANSFORMATIONS } from "./LocalTransformations";
import { MINING_SCHEMA } from "./MiningSchema";
import { MODEL_STATS } from "./ModelStats";
import { MODEL_VERIFICATION } from "./ModelVerification";
import { OUTPUT } from "./Output";
export const ASSOCIATION_MODEL = `
elements.elements[(name = "AssociationModel")] ~> $map(function($v, $i) {
  $merge([
    $associationModelFactory(),
    $v.attributes,
    {
      "_type": $v.name
    },
    {
      ${MINING_SCHEMA}, 
      ${OUTPUT},
      ${MODEL_STATS},
      ${MODEL_VERIFICATION},
      ${LOCAL_TRANSFORMATIONS}
    }
  ])
})`;
export function associationModelFactory() {
    return new AssociationModel({
        MiningSchema: new MiningSchema({ MiningField: [] }),
        functionName: "regression",
        numberOfTransactions: 0,
        minimumSupport: 0,
        minimumConfidence: 0,
        numberOfItems: 0,
        numberOfItemsets: 0,
        numberOfRules: 0,
    });
}
//# sourceMappingURL=AssociationModel.js.map