import { domParser, getInstanceNs, getParser } from "@kie-tools/xml-parser-ts";
import { meta as scesim18meta, root as scesim18root, subs as scesim18subs, elements as scesim18elements, ns as scesim18ns, } from "./schemas/scesim-1_8/ts-gen/meta";
export function getMarshaller(xml) {
    const domdoc = domParser.getDomDocument(xml);
    const instanceNs = getInstanceNs(domdoc);
    const p = getParser({
        ns: scesim18ns,
        meta: scesim18meta,
        subs: scesim18subs,
        elements: scesim18elements,
        root: scesim18root,
    });
    return {
        instanceNs,
        version: "1.8",
        root: scesim18root,
        meta: scesim18meta,
        parser: { parse: () => p.parse({ type: "domdoc", domdoc, instanceNs }).json },
        builder: { build: (json) => p.build({ json, instanceNs }) },
    };
}
//# sourceMappingURL=index.js.map