import { HttpMethod } from "../../fetch/FetchConstants";
import { ResourceFetch } from "../../fetch/ResourceFetch";
import { SelfSubjectAccessReview } from "kubernetes-models/authorization.k8s.io/v1";
import { ResourceDataSource } from "../common";
export const SELF_SUBJECT_ACCESS_REVIEW_TEMPLATE = (args) => {
    return new SelfSubjectAccessReview({
        spec: {
            resourceAttributes: {
                resource: args.resource,
                verb: "*",
                namespace: args.namespace,
            },
        },
    }).toJSON();
};
export class CreateSelfSubjectAccessReview extends ResourceFetch {
    constructor(args) {
        super(args);
        this.args = args;
    }
    method() {
        return HttpMethod.POST;
    }
    body() {
        return JSON.stringify(this.args.resourceDataSource === ResourceDataSource.PROVIDED
            ? this.args.descriptor
            : SELF_SUBJECT_ACCESS_REVIEW_TEMPLATE({ ...this.args }));
    }
    endpoint() {
        return `/apis/${SelfSubjectAccessReview.apiVersion}/selfsubjectaccessreviews`;
    }
}
//# sourceMappingURL=SelfSubjectAccessReview.js.map