import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { FormGroup, Form } from "@patternfly/react-core/dist/js/components/Form";
import { Card, CardBody, CardHeaderMain, CardHeader } from "@patternfly/react-core/dist/js/components/Card";
import { TextVariants, Text } from "@patternfly/react-core/dist/js/components/Text";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import Moment from "react-moment";
const FormCard = ({ formData, driver, ouiaId, ouiaSafe }) => {
    const getLabel = () => {
        switch (formData.type) {
            case "HTML":
                return _jsx(Label, { variant: "outline", children: "HTML" });
            case "TSX":
                return _jsx(Label, { variant: "outline", children: "REACT" });
            default:
                return "";
        }
    };
    const handleCardClick = () => {
        driver.openForm(formData);
    };
    return (_jsxs(Card, { ...componentOuiaProps(ouiaId, "forms-card", ouiaSafe), isSelectable: true, onClick: handleCardClick, children: [_jsx(CardHeader, { children: _jsx(CardHeaderMain, { children: getLabel() }) }), _jsx(CardHeader, { children: _jsx(Text, { component: TextVariants.h1, className: "pf-u-font-weight-bold", children: formData.name }) }), _jsx(CardBody, { children: _jsx("div", { className: "pf-u-mt-md", children: _jsxs(Form, { children: [_jsx(FormGroup, { label: "Type", fieldId: "type", children: _jsx(Text, { component: TextVariants.p, children: formData.type }) }), _jsx(FormGroup, { label: "LastModified", fieldId: "lastModified", children: _jsx(Text, { component: TextVariants.p, children: _jsx(Moment, { fromNow: true, children: formData.lastModified }) }) })] }) }) })] }));
};
export default FormCard;
//# sourceMappingURL=FormCard.js.map