import { jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import { useEffect, useRef, useState } from "react";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { ServerErrors } from "@kie-tools/runtime-tools-components/dist/components/ServerErrors";
import { Card } from "@patternfly/react-core/dist/js/components/Card";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
const CustomDashboardView = ({ isEnvelopeConnectedToChannel, driver, ouiaId, customDashboardName, targetOrigin, ouiaSafe, }) => {
    const ref = useRef(null);
    const [dashboardContent, setDashboardContent] = useState();
    const [errorMessage, setErrorMessage] = useState();
    const [isError, setError] = useState(false);
    const [isReady, setReady] = useState(false);
    driver
        .getCustomDashboardContent(customDashboardName)
        .then((value) => setDashboardContent(value))
        .catch((error) => {
        setError(true);
        setErrorMessage(error.message);
    });
    window.addEventListener("message", (e) => {
        if (e.origin !== targetOrigin) {
            return;
        }
        if (e.data == "ready") {
            setReady(true);
        }
    });
    useEffect(() => {
        var _a, _b;
        if (isReady && ref) {
            (_b = (_a = ref.current) === null || _a === void 0 ? void 0 : _a.contentWindow) === null || _b === void 0 ? void 0 : _b.postMessage(dashboardContent, "*");
        }
    });
    return (_jsx(_Fragment, { children: isError ? (_jsx(_Fragment, { children: isEnvelopeConnectedToChannel && (_jsx(Card, { className: "kogito-custom-dashboard-view-__card-size", children: _jsx(Bullseye, { children: _jsx(ServerErrors, { error: errorMessage, variant: "large" }) }) })) })) : (_jsx("iframe", { ref: ref, id: "db", src: "resources/webapp/custom-dashboard-view/dashbuilder/index.html", style: { width: "100%", height: "100%", padding: "10px" }, ...componentOuiaProps(ouiaId, "customDashboard-view", ouiaSafe) })) }));
};
export default CustomDashboardView;
//# sourceMappingURL=CustomDashboardView.js.map