import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import { useCallback, useMemo } from "react";
import { BeeTableHeaderVisibility } from "../../api";
import { BeeTableTdForAdditionalRow } from "./BeeTableTdForAdditionalRow";
import { BeeTableTd } from "./BeeTableTd";
import { BeeTableCoordinatesContextProvider } from "../../selection/BeeTableSelectionContext";
import { useBoxedExpressionEditor } from "../../BoxedExpressionEditorContext";
export function BeeTableBody({ reactTableInstance, additionalRow, headerVisibility, getRowKey, getColumnKey, onRowAdded, onDataCellClick, onDataCellKeyUp, shouldRenderRowIndexColumn, shouldShowRowsInlineControls, resizerStopBehavior, lastColumnMinWidth, rowWrapper, isReadOnly, supportsEvaluationHitsCount, }) {
    const { evaluationHitsCountById } = useBoxedExpressionEditor();
    const renderRow = useCallback((row, rowIndex) => {
        var _a, _b;
        reactTableInstance.prepareRow(row);
        const rowKey = getRowKey(row);
        const rowEvaluationHitsCount = evaluationHitsCountById ? (_a = evaluationHitsCountById === null || evaluationHitsCountById === void 0 ? void 0 : evaluationHitsCountById.get(rowKey)) !== null && _a !== void 0 ? _a : 0 : undefined;
        const canDisplayEvaluationHitsCountRowOverlay = rowEvaluationHitsCount !== undefined && ((_b = supportsEvaluationHitsCount === null || supportsEvaluationHitsCount === void 0 ? void 0 : supportsEvaluationHitsCount(row)) !== null && _b !== void 0 ? _b : false);
        const rowClassName = `${rowKey}${canDisplayEvaluationHitsCountRowOverlay && rowEvaluationHitsCount > 0 ? " evaluation-hits-count-row-overlay" : ""}`;
        let evaluationHitsCountBadgeColumnIndex = -1;
        const renderTr = () => (_jsx("tr", { className: rowClassName, "data-testid": `kie-tools--bee--expression-row-${rowIndex}`, children: row.cells.map((cell, cellIndex) => {
                const columnKey = getColumnKey(reactTableInstance.allColumns[cellIndex]);
                const isColumnToRender = (cell.column.isRowIndexColumn && shouldRenderRowIndexColumn) || !cell.column.isRowIndexColumn;
                if (evaluationHitsCountBadgeColumnIndex === -1 && isColumnToRender) {
                    evaluationHitsCountBadgeColumnIndex = cellIndex;
                }
                const canDisplayEvaluationHitsCountBadge = canDisplayEvaluationHitsCountRowOverlay && cellIndex === evaluationHitsCountBadgeColumnIndex;
                return (_jsx(React.Fragment, { children: isColumnToRender && (_jsx(BeeTableTd, { resizerStopBehavior: resizerStopBehavior, shouldShowRowsInlineControls: shouldShowRowsInlineControls, columnIndex: cellIndex, row: row, rowIndex: rowIndex, column: reactTableInstance.allColumns[cellIndex], onDataCellClick: onDataCellClick, onDataCellKeyUp: onDataCellKeyUp, onRowAdded: onRowAdded, isActive: false, shouldRenderInlineButtons: shouldRenderRowIndexColumn
                            ? reactTableInstance.allColumns[cellIndex].isRowIndexColumn
                            : cellIndex === 1, lastColumnMinWidth: cellIndex === reactTableInstance.allColumns.length - 1 ? lastColumnMinWidth : undefined, isReadOnly: isReadOnly, canDisplayEvaluationHitsCountBadge: canDisplayEvaluationHitsCountBadge, evaluationHitsCount: rowEvaluationHitsCount })) }, columnKey));
            }) }, rowKey));
        const RowWrapper = rowWrapper;
        return (_jsx(React.Fragment, { children: RowWrapper ? (_jsx(RowWrapper, { rowIndex: rowIndex, row: row.original, children: renderTr() })) : (_jsx(_Fragment, { children: renderTr() })) }, rowKey));
    }, [
        evaluationHitsCountById,
        supportsEvaluationHitsCount,
        reactTableInstance,
        rowWrapper,
        getRowKey,
        getColumnKey,
        shouldRenderRowIndexColumn,
        resizerStopBehavior,
        shouldShowRowsInlineControls,
        onDataCellClick,
        onDataCellKeyUp,
        onRowAdded,
        lastColumnMinWidth,
        isReadOnly,
    ]);
    const additionalRowIndex = useMemo(() => {
        return reactTableInstance.rows.length;
    }, [reactTableInstance.rows.length]);
    return (_jsxs("tbody", { className: `${headerVisibility === BeeTableHeaderVisibility.None ? "missing-header" : ""}`, ...reactTableInstance.getTableBodyProps(), children: [reactTableInstance.rows.map((row, rowIndex) => {
                return renderRow(row, rowIndex);
            }), additionalRow && (_jsxs("tr", { className: "additional-row", "data-ouia-component-id": "additional-row", "data-testid": "kie-tools--bee--additional-row", children: [shouldRenderRowIndexColumn && (_jsx(BeeTableCoordinatesContextProvider, { coordinates: { rowIndex: additionalRowIndex, columnIndex: 0 }, children: _jsx(BeeTableTdForAdditionalRow, { row: undefined, rowIndex: additionalRowIndex, columnIndex: 0, column: reactTableInstance.allColumns[0], isLastColumn: false, isEmptyCell: true, resizerStopBehavior: resizerStopBehavior, isReadOnly: isReadOnly }) })), additionalRow.map((elem, elemIndex) => {
                        const columnIndex = elemIndex + 1;
                        return (_jsx(BeeTableCoordinatesContextProvider, { coordinates: { rowIndex: additionalRowIndex, columnIndex }, children: _jsx(BeeTableTdForAdditionalRow, { row: undefined, rowIndex: additionalRowIndex, column: reactTableInstance.allColumns[columnIndex], columnIndex: columnIndex, isLastColumn: elemIndex === additionalRow.length - 1, isEmptyCell: false, resizerStopBehavior: resizerStopBehavior, lastColumnMinWidth: columnIndex === additionalRow.length - 1 ? lastColumnMinWidth : undefined, isReadOnly: isReadOnly, children: elem }, columnIndex) }, columnIndex));
                    })] }))] }));
}
//# sourceMappingURL=BeeTableBody.js.map