import { jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import { useEffect, useMemo, useRef } from "react";
const BeeTableCellWidthsToFitDataContext = React.createContext({});
const BeeTableCellWidthsToFitDataDispatchContext = React.createContext({});
export function BeeTableCellWidthsToFitDataContextProvider({ children }) {
    const refs = useRef(new Map());
    const value = useMemo(() => ({
        getRefs: () => refs.current,
    }), []);
    const dispatch = useMemo(() => {
        return {
            registerCellWidthToFitDataRef: (rowIndex, columnIndex, ref) => {
                var _a;
                const columnsMap = new Map((_a = refs.current.get(rowIndex)) !== null && _a !== void 0 ? _a : new Map());
                if (columnsMap === null || columnsMap === void 0 ? void 0 : columnsMap.get(columnIndex)) {
                    throw new Error(`Can't have two cells registered for the same coordinates (${rowIndex}, ${columnIndex})`);
                }
                else {
                    columnsMap === null || columnsMap === void 0 ? void 0 : columnsMap.set(columnIndex, ref);
                }
                refs.current.set(rowIndex, columnsMap);
                return ref;
            },
            deregisterCellWidthToFitDataRef: (rowIndex, columnIndex, ref) => {
                var _a;
                const columnsMap = new Map((_a = refs.current.get(rowIndex)) !== null && _a !== void 0 ? _a : new Map());
                if (columnsMap === null || columnsMap === void 0 ? void 0 : columnsMap.get(columnIndex)) {
                    columnsMap === null || columnsMap === void 0 ? void 0 : columnsMap.delete(columnIndex);
                }
                else {
                    throw new Error(`Can't delete unregistered cell for coordinates (${rowIndex}, ${columnIndex})`);
                }
                refs.current.set(rowIndex, columnsMap);
            },
        };
    }, []);
    return (_jsx(BeeTableCellWidthsToFitDataContext.Provider, { value: value, children: _jsx(BeeTableCellWidthsToFitDataDispatchContext.Provider, { value: dispatch, children: children }) }));
}
export function useCellWidthsToFitData() {
    return React.useContext(BeeTableCellWidthsToFitDataContext);
}
export function useCellWidthsToFitDataDispatch() {
    return React.useContext(BeeTableCellWidthsToFitDataDispatchContext);
}
export function useCellWidthToFitData(rowIndex, columnIndex) {
    const { getRefs } = useCellWidthsToFitData();
    return useMemo(() => ({
        getWidthToFitData: () => { var _a, _b; return (_b = (_a = getRefs().get(rowIndex)) === null || _a === void 0 ? void 0 : _a.get(columnIndex)) === null || _b === void 0 ? void 0 : _b.getWidthToFitData(); },
    }), [columnIndex, getRefs, rowIndex]);
}
export function useCellWidthToFitDataRef(rowIndex, columnIndex, ref) {
    const { registerCellWidthToFitDataRef, deregisterCellWidthToFitDataRef } = useCellWidthsToFitDataDispatch();
    useEffect(() => {
        const r = registerCellWidthToFitDataRef(rowIndex, columnIndex, ref);
        return () => {
            deregisterCellWidthToFitDataRef(rowIndex, columnIndex, r);
        };
    }, [columnIndex, deregisterCellWidthToFitDataRef, ref, registerCellWidthToFitDataRef, rowIndex]);
}
//# sourceMappingURL=BeeTableCellWidthToFitDataContext.js.map