import { meta as dmn15meta, elements as dmn15elements, } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/ts-gen/meta";
import { XmlParserTsIdRandomizer } from "@kie-tools/xml-parser-ts/dist/idRandomizer";
import { generateUuid } from "../api";
export function findAllIdsDeep(expression) {
    if (!expression) {
        return new Set();
    }
    return getIdRandomizerForExpression(expression).getOriginalIds();
}
export function mutateExpressionRandomizingIds(expression) {
    if (!expression) {
        return new Map();
    }
    return getIdRandomizerForExpression(expression).randomize({ skipAlreadyAttributedIds: false }).getRandomized();
}
function getNewBeeIdRandomizer() {
    return new XmlParserTsIdRandomizer({
        meta: dmn15meta,
        elements: dmn15elements,
        newIdGenerator: generateUuid,
        matchers: [],
    });
}
function getIdRandomizerForExpression(expression) {
    return getNewBeeIdRandomizer().ack({
        json: { __$$element: "decision", expression },
        type: "DMN15__tDecision",
        attr: "expression",
    });
}
//# sourceMappingURL=ids.js.map