"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.executeOnSaveHook = executeOnSaveHook;
var vscode = require("vscode");
function executeOnSaveHook(fileType) {
    if (!fileType) {
        return;
    }
    var hookId = "kogito.".concat(fileType, ".runOnSave");
    var hook = vscode.workspace.getConfiguration().get(hookId, "");
    if (hook) {
        vscode.commands.executeCommand(hook);
    }
}
//# sourceMappingURL=onSaveHook.js.map