"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VsCodeNotificationsChannelApiImpl = void 0;
var core_1 = require("@kie-tools-core/i18n/dist/core");
var vscode = require("vscode");
var PopupMessagesNotificationHandler_1 = require("./PopupMessagesNotificationHandler");
var ProblemsTabNotificationHandler_1 = require("./ProblemsTabNotificationHandler");
var i18n_1 = require("./i18n");
var VsCodeNotificationsChannelApiImpl = (function () {
    function VsCodeNotificationsChannelApiImpl(vscodeWorkspace, i18n) {
        if (i18n === void 0) { i18n = new core_1.I18n(i18n_1.notificationsApiVsCodeI18nDefaults, i18n_1.notificationsApiVsCodeI18nDictionaries, vscode.env.language); }
        this.vscodeWorkspace = vscodeWorkspace;
        this.i18n = i18n;
        this.strategies = {
            PROBLEM: new ProblemsTabNotificationHandler_1.ProblemsTabNotificationHandler(),
            ALERT: new PopupMessagesNotificationHandler_1.PopupMessagesNotificationHandler(this.vscodeWorkspace, this.i18n),
        };
    }
    VsCodeNotificationsChannelApiImpl.prototype.createNotification = function (document, notification) {
        if (notification.type === "ALERT") {
            this.strategies.ALERT.createNotification(notification);
        }
        else if (notification.type === "PROBLEM") {
            this.strategies.PROBLEM.createNotification(document, notification);
        }
        else {
            throw new Error("Unknown notification type ".concat(notification.type));
        }
    };
    VsCodeNotificationsChannelApiImpl.prototype.setNotifications = function (document, normalizedPosixPathRelativeToTheWorkspaceRoot, notifications) {
        this.strategies.PROBLEM.setProblemsEntries(document, normalizedPosixPathRelativeToTheWorkspaceRoot, notifications.filter(function (n) { return n.type === "PROBLEM"; }));
        this.strategies.ALERT.showAlert(normalizedPosixPathRelativeToTheWorkspaceRoot, notifications.filter(function (n) { return n.type === "ALERT"; }));
    };
    VsCodeNotificationsChannelApiImpl.prototype.removeNotifications = function (document, normalizedPosixPathRelativeToTheWorkspaceRoot) {
        this.strategies.PROBLEM.removeNotifications(document, normalizedPosixPathRelativeToTheWorkspaceRoot);
    };
    return VsCodeNotificationsChannelApiImpl;
}());
exports.VsCodeNotificationsChannelApiImpl = VsCodeNotificationsChannelApiImpl;
//# sourceMappingURL=VsCodeNotificationsChannelApiImpl.js.map