import { EditorEnvelopeLocator } from "@kie-tools-core/editor/dist/api";
import { I18n } from "@kie-tools-core/i18n/dist/core";
import { WorkspaceEdit } from "@kie-tools-core/workspace/dist/api";
import * as vscode from "vscode";
import { CancellationToken, CustomDocument, CustomDocumentBackup, Uri } from "vscode";
import { VsCodeKieEditorController } from "./VsCodeKieEditorController";
import { VsCodeKieEditorStore } from "./VsCodeKieEditorStore";
import { VsCodeI18n } from "./i18n";
import { VsCodeNotificationsChannelApiImpl } from "./notifications/VsCodeNotificationsChannelApiImpl";
export declare class VsCodeKieEditorCustomDocument implements CustomDocument {
    readonly uri: Uri;
    readonly initialBackup: Uri | undefined;
    readonly editorStore: VsCodeKieEditorStore;
    private readonly vsCodeI18n;
    private readonly vscodeNotifications;
    private readonly editorEnvelopeLocator;
    private readonly encoder;
    private readonly decoder;
    private readonly vsCodeLogger;
    private readonly _onDidDispose;
    readonly onDidDispose: vscode.Event<void>;
    private readonly _onDidChange;
    readonly onDidChange: vscode.Event<vscode.CustomDocumentEditEvent<VsCodeKieEditorCustomDocument>>;
    constructor(uri: Uri, initialBackup: Uri | undefined, editorStore: VsCodeKieEditorStore, vsCodeI18n: I18n<VsCodeI18n>, vscodeNotifications: VsCodeNotificationsChannelApiImpl, editorEnvelopeLocator: EditorEnvelopeLocator);
    dispose(): void;
    get normalizedPosixPathRelativeToTheWorkspaceRoot(): string;
    get fileExtension(): string;
    get fileType(): string | undefined;
    save(destination: Uri, cancellation: CancellationToken): Promise<void>;
    backup(destination: Uri, cancellation: CancellationToken): Promise<CustomDocumentBackup>;
    revert(cancellation: CancellationToken): Promise<void>;
    notifyEdit(editor: VsCodeKieEditorController, edit: WorkspaceEdit): void;
}
//# sourceMappingURL=VsCodeKieEditorCustomDocument.d.ts.map