"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createWorkspaceServices = createWorkspaceServices;
var FsFlushManager_1 = require("../services/FsFlushManager");
var GitService_1 = require("../services/GitService");
var StorageService_1 = require("../services/StorageService");
var WorkspaceDescriptorFsService_1 = require("../services/WorkspaceDescriptorFsService");
var WorkspaceDescriptorService_1 = require("../services/WorkspaceDescriptorService");
var WorkspaceFsService_1 = require("../services/WorkspaceFsService");
var WorkspaceService_1 = require("../services/WorkspaceService");
function createWorkspaceServices(args) {
    var fsFlushManager = new FsFlushManager_1.FsFlushManager();
    var storageService = new StorageService_1.StorageService();
    var workspaceFsService = new WorkspaceFsService_1.WorkspaceFsService(fsFlushManager);
    var descriptorsFsService = new WorkspaceDescriptorFsService_1.WorkspaceDescriptorFsService(fsFlushManager);
    var descriptorService = new WorkspaceDescriptorService_1.WorkspaceDescriptorService(descriptorsFsService, storageService);
    var gitService = new GitService_1.GitService(args.corsProxyUrl);
    var workspaceService = new WorkspaceService_1.WorkspaceService(storageService, descriptorsFsService, descriptorService, workspaceFsService);
    return {
        fsFlushManager: fsFlushManager,
        storageService: storageService,
        workspaceFsService: workspaceFsService,
        descriptorsFsService: descriptorsFsService,
        descriptorService: descriptorService,
        workspaceService: workspaceService,
        gitService: gitService,
    };
}
//# sourceMappingURL=createWorkspaceServices.js.map