import { GIT_DEFAULT_BRANCH } from "../../constants/GitConstants";
export declare enum WorkspaceKind {
    GITHUB_GIST = "GITHUB_GIST",
    GIT = "GIT",
    LOCAL = "LOCAL",
    BITBUCKET_SNIPPET = "BITBUCKET_SNIPPET"
}
declare const gitBasedTypeKeys: readonly [WorkspaceKind.GIT, WorkspaceKind.BITBUCKET_SNIPPET, WorkspaceKind.GITHUB_GIST];
export type WorkspaceKindGitBased = (typeof gitBasedTypeKeys)[number];
export declare const isGitBasedWorkspaceKind: (maybeGitBasedType: WorkspaceKind | undefined) => maybeGitBasedType is WorkspaceKindGitBased;
declare const gistLikeTypeKeys: readonly [WorkspaceKind.GITHUB_GIST, WorkspaceKind.BITBUCKET_SNIPPET];
export type WorkspaceKindGistLike = (typeof gistLikeTypeKeys)[number];
export declare const isGistLikeWorkspaceKind: (maybeGistLikeType: WorkspaceKind | undefined) => maybeGistLikeType is WorkspaceKindGistLike;
export type WorkspaceOrigin = LocalOrigin | GistOrigin | GitHubOrigin | BitbucketOrigin | SnippetOrigin;
export interface LocalOrigin {
    kind: WorkspaceKind.LOCAL;
    branch: typeof GIT_DEFAULT_BRANCH;
    url?: string;
}
export interface GitHubOrigin {
    kind: WorkspaceKind.GIT;
    url: string;
    branch: string;
}
export interface BitbucketOrigin {
    kind: WorkspaceKind.GIT;
    url: string;
    branch: string;
}
export interface GistOrigin {
    kind: WorkspaceKind.GITHUB_GIST;
    url: string;
    branch: string;
}
export interface SnippetOrigin {
    kind: WorkspaceKind.BITBUCKET_SNIPPET;
    url: string;
    branch: string;
}
export {};
//# sourceMappingURL=WorkspaceOrigin.d.ts.map