import { WorkspaceDescriptor } from "../worker/api/WorkspaceDescriptor";
import { LfsStorageService } from "./LfsStorageService";
export type CreateDescriptorArgs = Partial<Pick<WorkspaceDescriptor, "workspaceId" | "origin">> & Pick<WorkspaceDescriptor, "name">;
export declare class LfsWorkspaceDescriptorService {
    private readonly storageService;
    private readonly descriptorFs;
    constructor(databaseName: string, storageService: LfsStorageService);
    listAll(): Promise<WorkspaceDescriptor[]>;
    bumpLastUpdatedDate(id: string): Promise<void>;
    exists(workspaceId: string): Promise<boolean>;
    get(workspaceId: string): Promise<WorkspaceDescriptor>;
    create(args: CreateDescriptorArgs): Promise<WorkspaceDescriptor>;
    delete(workspaceId: string): Promise<void>;
    rename(workspaceId: string, newName: string): Promise<void>;
    private toStorageFile;
    private getAbsolutePath;
    private newWorkspaceId;
}
//# sourceMappingURL=LfsWorkspaceDescriptorService.d.ts.map