import { getJobs, getTriggerableNodes, getWorkflowDetails, handleJobReschedule, handleNodeInstanceCancel, handleNodeInstanceRetrigger, handleNodeTrigger, handleWorkflowAbort, handleWorkflowRetry, handleWorkflowSkip, handleWorkflowVariableUpdate, jobCancel, } from "@kie-tools/runtime-tools-swf-gateway-api/dist/gatewayApi";
export class GraphQLWorkflowDetailsQueries {
    constructor(client) {
        this.client = client;
    }
    async getWorkflowDetails(id) {
        return getWorkflowDetails(id, this.client);
    }
    async getJobs(id) {
        return Promise.resolve(getJobs(id, this.client));
    }
    async handleWorkflowSkip(workflowInstance) {
        return handleWorkflowSkip(workflowInstance, this.client);
    }
    async handleWorkflowAbort(workflowInstance) {
        return handleWorkflowAbort(workflowInstance, this.client);
    }
    async handleWorkflowRetry(workflowInstance) {
        return handleWorkflowRetry(workflowInstance, this.client);
    }
    async jobCancel(job) {
        return jobCancel(job, this.client);
    }
    async rescheduleJob(job, repeatInterval, repeatLimit, scheduleDate) {
        return handleJobReschedule(job, repeatInterval, repeatLimit, scheduleDate, this.client);
    }
    async getTriggerableNodes(workflowInstance) {
        return Promise.resolve(getTriggerableNodes(workflowInstance, this.client));
    }
    async handleNodeTrigger(workflowInstance, node) {
        return handleNodeTrigger(workflowInstance, node, this.client);
    }
    async handleNodeInstanceCancel(workflowInstance, node) {
        return handleNodeInstanceCancel(workflowInstance, node, this.client);
    }
    async handleWorkflowVariableUpdate(workflowInstance, updateJson) {
        return handleWorkflowVariableUpdate(workflowInstance, updateJson, this.client);
    }
    async handleNodeInstanceRetrigger(workflowInstance, node) {
        return handleNodeInstanceRetrigger(workflowInstance, node, this.client);
    }
}
//# sourceMappingURL=WorkflowDetailsQueries.js.map