import { jsx as _jsx } from "react/jsx-runtime";
import { useMemo } from "react";
import { ApolloClient } from "apollo-client";
import { WorkflowDetailsContext } from "./WorkflowDetailsContext";
import { WorkflowDetailsGatewayApiImpl } from "./WorkflowDetailsGatewayApi";
import { GraphQLWorkflowDetailsQueries } from "./WorkflowDetailsQueries";
import { HttpLink } from "apollo-link-http";
import { InMemoryCache } from "apollo-cache-inmemory";
export function WorkflowDetailsContextProvider(props) {
    const { proxyEndpoint, dataIndexUrl } = props;
    const httpLink = useMemo(() => new HttpLink({
        uri: proxyEndpoint || dataIndexUrl,
        headers: {
            ...(proxyEndpoint ? { "Target-Url": dataIndexUrl } : {}),
        },
    }), [dataIndexUrl, proxyEndpoint]);
    const cache = useMemo(() => new InMemoryCache(), []);
    const apolloClient = useMemo(() => new ApolloClient({
        cache,
        link: httpLink,
    }), [cache, httpLink]);
    return (_jsx(WorkflowDetailsContextProviderWithApolloClient, { apolloClient: apolloClient, children: props.children }));
}
export function WorkflowDetailsContextProviderWithApolloClient(props) {
    const { apolloClient } = props;
    const gatewayApiImpl = useMemo(() => {
        return new WorkflowDetailsGatewayApiImpl(new GraphQLWorkflowDetailsQueries(apolloClient));
    }, [apolloClient]);
    return _jsx(WorkflowDetailsContext.Provider, { value: gatewayApiImpl, children: props.children });
}
//# sourceMappingURL=WorkflowDetailsContextProvider.js.map