"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.swfRefValidationMap = void 0;
exports.swfRefValidationMap = new Map([
    [
        {
            name: "auth",
            path: ["auth", "*", "name"],
        },
        [
            {
                path: ["functions", "*", "authRef"],
                type: "string",
            },
        ],
    ],
    [
        {
            name: "retries",
            path: ["retries", "*", "name"],
        },
        [
            {
                path: ["states", "*", "actions", "*", "retryRef"],
                type: "string",
            },
            {
                path: ["onEvents", "*", "actions", "*", "retryRef"],
                type: "string",
            },
        ],
    ],
    [
        {
            name: "events",
            path: ["events", "*", "name"],
        },
        [
            {
                path: ["onEvents", "*", "eventRefs"],
                type: "string",
                isArray: true,
            },
            {
                path: ["states", "*", "actions", "*", "functionRef", "name"],
                type: "string",
            },
            {
                path: ["onEvents", "*", "actions", "*", "eventRef", "resultEventRef"],
                type: "string",
            },
            {
                path: ["onEvents", "*", "actions", "*", "eventRef", "triggerEventRef"],
                type: "string",
            },
            {
                path: ["states", "*", "transition", "produceEvents", "*", "eventRef"],
                type: "string",
            },
            {
                path: ["states", "*", "dataConditions", "*", "transition", "produceEvents", "*", "eventRef"],
                type: "string",
            },
            {
                path: ["states", "*", "eventConditions", "*", "eventRef"],
                type: "string",
            },
            {
                path: ["states", "*", "eventConditions", "*", "transition", "produceEvents", "*", "eventRef"],
                type: "string",
            },
        ],
    ],
    [
        {
            name: "functions",
            path: ["functions", "*", "name"],
        },
        [
            {
                path: ["states", "*", "actions", "*", "functionRef"],
                type: "string",
            },
            {
                path: ["states", "*", "actions", "*", "functionRef", "refName"],
                type: "string",
            },
            {
                path: ["onEvents", "*", "actions", "*", "functionRef"],
                type: "string",
            },
            {
                path: ["onEvents", "*", "actions", "*", "functionRef", "refName"],
                type: "string",
            },
        ],
    ],
    [
        {
            name: "errors",
            path: ["errors", "*", "name"],
        },
        [
            {
                path: ["states", "*", "actions", "*", "retryableErrors"],
                type: "string",
                isArray: true,
            },
            {
                path: ["states", "*", "actions", "*", "nonRetryableErrors"],
                type: "string",
                isArray: true,
            },
            {
                path: ["states", "*", "onErrors", "*", "errorRef"],
                type: "string",
            },
            {
                path: ["states", "*", "onErrors", "*", "errorRefs"],
                type: "string",
                isArray: true,
            },
            {
                path: ["onEvents", "*", "actions", "*", "retryableErrors"],
                type: "string",
                isArray: true,
            },
            {
                path: ["onEvents", "*", "actions", "*", "nonRetryableErrors"],
                type: "string",
                isArray: true,
            },
        ],
    ],
    [
        {
            name: "states",
            path: ["states", "*", "name"],
        },
        [
            {
                path: ["start"],
                type: "string",
            },
            {
                path: ["start", "stateName"],
                type: "string",
            },
            {
                path: ["states", "*", "transition"],
                type: "string",
            },
            {
                path: ["states", "*", "transition", "nextState"],
                type: "string",
            },
            {
                path: ["states", "*", "compensatedBy"],
                type: "string",
            },
            {
                path: ["states", "*", "dataConditions", "*", "transition"],
                type: "string",
            },
            {
                path: ["states", "*", "dataConditions", "*", "transition", "nextState"],
                type: "string",
            },
            {
                path: ["states", "*", "eventConditions", "*", "transition"],
                type: "string",
            },
            {
                path: ["states", "*", "eventConditions", "*", "transition", "nextState"],
                type: "string",
            },
        ],
    ],
]);
//# sourceMappingURL=swfRefValidationMap.js.map