"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SwfLanguageServiceCodeCompletion = void 0;
var channel_1 = require("@kie-tools/json-yaml-language-service/dist/channel");
var utils_1 = require("@kie-tools/serverless-workflow-jq-expressions/dist/utils");
var api_1 = require("@kie-tools/serverless-workflow-service-catalog/dist/api");
var vscode_languageserver_types_1 = require("vscode-languageserver-types");
var code_completions_1 = require("../assets/code-completions");
var swfModelQueries = require("./modelQueries");
function toCompletionItemLabel(namespace, resource, operation) {
    return "".concat(namespace, "\u00BB").concat(resource, "#").concat(operation);
}
function isRemotePath(pathUri) {
    return /^(http|https|file):\/\//.test(pathUri);
}
function toCompletionItemLabelPrefix(swfServiceCatalogFunction, specsDirRelativePosixPath) {
    var _a;
    switch (swfServiceCatalogFunction.source.type) {
        case api_1.SwfCatalogSourceType.LOCAL_FS:
            var fileName = (_a = swfServiceCatalogFunction.source.serviceFileAbsolutePath.split("/").pop()) !== null && _a !== void 0 ? _a : swfServiceCatalogFunction.source.serviceFileAbsolutePath;
            return toCompletionItemLabel(specsDirRelativePosixPath, fileName, swfServiceCatalogFunction.name);
        case api_1.SwfCatalogSourceType.SERVICE_REGISTRY:
            return toCompletionItemLabel(swfServiceCatalogFunction.source.registry, swfServiceCatalogFunction.source.serviceId, swfServiceCatalogFunction.name);
        default:
            return "";
    }
}
function getStateNameCompletion(args) {
    return args.states.flatMap(function (state) {
        var kind = vscode_languageserver_types_1.CompletionItemKind.Value;
        var label = args.codeCompletionStrategy.formatLabel(state.name, kind);
        return [
            (0, channel_1.createCompletionItem)(__assign(__assign({}, args), { completion: "".concat(state.name), kind: kind, label: label, detail: "\"".concat(state.name, "\"") })),
        ];
    });
}
function extractFunctionsPath(functionsNode) {
    var relativeList = [];
    var remoteList = [];
    functionsNode.forEach(function (func) {
        var _a, _b, _c;
        var functionType = (_b = (_a = (0, channel_1.findNodeAtLocation)(func, ["type"])) === null || _a === void 0 ? void 0 : _a.value.trim()) !== null && _b !== void 0 ? _b : "rest";
        if (functionType == "rest" || functionType == "asyncapi") {
            var path = (_c = (0, channel_1.findNodeAtLocation)(func, ["operation"])) === null || _c === void 0 ? void 0 : _c.value.split("#")[0];
            if (path) {
                if (isRemotePath(path)) {
                    remoteList.push(path);
                }
                else {
                    relativeList.push(path);
                }
            }
        }
    });
    return { relativeList: relativeList, remoteList: remoteList };
}
function getJqCompletionWordToSearch(slicedValue) {
    var removeSpecialChar = slicedValue.replace(/[^a-zA-Z _()]/g, "");
    var builtInFunctionMatch = removeSpecialChar.match(/\s(\w+)?$/);
    if (builtInFunctionMatch === null && removeSpecialChar.length) {
        return removeSpecialChar.trim();
    }
    else if (builtInFunctionMatch && builtInFunctionMatch[1] === undefined) {
        return "";
    }
    else if (builtInFunctionMatch && builtInFunctionMatch[1].length) {
        return builtInFunctionMatch[1];
    }
    return "";
}
var getJqInputVariablesCompletions = function getJqInputVariablesCompletions(args) {
    return __awaiter(this, void 0, void 0, function () {
        var showAllCompletion, _a, relativeList, remoteList, dataInputSchemaPath, schemaData, _b, _c, _d, _e;
        var _f, _g;
        return __generator(this, function (_h) {
            switch (_h.label) {
                case 0:
                    showAllCompletion = !args.wordToSearch.length ? true : false;
                    _a = extractFunctionsPath((_f = (0, channel_1.findNodeAtLocation)(args.rootNode, ["functions"])) === null || _f === void 0 ? void 0 : _f.children), relativeList = _a.relativeList, remoteList = _a.remoteList;
                    dataInputSchemaPath = (_g = (0, channel_1.findNodeAtLocation)(args.rootNode, ["dataInputSchema"])) === null || _g === void 0 ? void 0 : _g.value;
                    if (dataInputSchemaPath) {
                        if (isRemotePath(dataInputSchemaPath)) {
                            remoteList.push(dataInputSchemaPath);
                        }
                        else {
                            relativeList.push(dataInputSchemaPath);
                        }
                    }
                    if (!(remoteList.length > 0 || relativeList.length > 0)) return [3, 4];
                    _c = (_b = Promise).all;
                    _d = [[]];
                    return [4, args.jqCompletions.remote.getJqAutocompleteProperties({
                            textDocument: args.document,
                            schemaPaths: remoteList !== null && remoteList !== void 0 ? remoteList : [],
                        })];
                case 1:
                    _e = [__spreadArray.apply(void 0, _d.concat([__read.apply(void 0, [(_h.sent())]), false]))];
                    return [4, args.jqCompletions.relative.getJqAutocompleteProperties({
                            textDocument: args.document,
                            schemaPaths: relativeList !== null && relativeList !== void 0 ? relativeList : [],
                        })];
                case 2: return [4, _c.apply(_b, [__spreadArray.apply(void 0, _e.concat([__read.apply(void 0, [(_h.sent())]), false]))])];
                case 3:
                    schemaData = _h.sent();
                    if (schemaData.length === 0) {
                        return [2, Promise.resolve([])];
                    }
                    return [2, Promise.resolve(schemaData
                            .filter(function (prop) {
                            return showAllCompletion ? true : Object.keys(prop)[0].startsWith(args.wordToSearch);
                        })
                            .map(function (parsedProp) {
                            return (0, channel_1.createCompletionItem)(__assign(__assign({}, args), { completion: Object.keys(parsedProp)[0], kind: vscode_languageserver_types_1.CompletionItemKind.Value, label: Object.keys(parsedProp)[0], detail: Object.values(parsedProp)[0], filterText: showAllCompletion ? Object.keys(parsedProp)[0] : args.wordToSearch, extraOptions: {
                                    insertText: Object.keys(parsedProp)[0],
                                }, overwriteRange: vscode_languageserver_types_1.Range.create(vscode_languageserver_types_1.Position.create(args.cursorPosition.line, showAllCompletion
                                    ? args.cursorPosition.character
                                    : args.cursorPosition.character - args.wordToSearch.length), vscode_languageserver_types_1.Position.create(args.cursorPosition.line, args.cursorPosition.character)) }));
                        }))];
                case 4: return [2, []];
            }
        });
    });
};
var getReusableFunctionCompletion = function (args) {
    return __awaiter(this, void 0, void 0, function () {
        var reusalbeFunctions, functionNamesArray, isWordToSearchExist, overwriteRange;
        var _a;
        return __generator(this, function (_b) {
            reusalbeFunctions = (0, channel_1.findNodeAtLocation)(args.rootNode, ["functions"]);
            functionNamesArray = [];
            isWordToSearchExist = args.wordToSearch.length ? true : false;
            overwriteRange = vscode_languageserver_types_1.Range.create(vscode_languageserver_types_1.Position.create(args.cursorPosition.line, args.cursorPosition.character - args.wordToSearch.length), vscode_languageserver_types_1.Position.create(args.cursorPosition.line, args.cursorPosition.character));
            if (reusalbeFunctions.type === "array") {
                (_a = reusalbeFunctions.children) === null || _a === void 0 ? void 0 : _a.forEach(function (func) {
                    var _a, _b;
                    if (((_a = (0, channel_1.findNodeAtLocation)(func, ["type"])) === null || _a === void 0 ? void 0 : _a.value) === "expression") {
                        var functionName = (_b = (0, channel_1.findNodeAtLocation)(func, ["name"])) === null || _b === void 0 ? void 0 : _b.value;
                        functionNamesArray.push(functionName);
                    }
                });
                return [2, functionNamesArray
                        .filter(function (name) { return (!isWordToSearchExist ? true : name.startsWith(args.wordToSearch)); })
                        .map(function (filteredName) {
                        return (0, channel_1.createCompletionItem)(__assign(__assign({}, args), { completion: filteredName, kind: vscode_languageserver_types_1.CompletionItemKind.Function, label: filteredName, filterText: isWordToSearchExist ? args.wordToSearch : filteredName, detail: "Reusable functions(expressions) defined in the functions array", extraOptions: {
                                insertText: filteredName,
                            }, overwriteRange: overwriteRange }));
                    })];
            }
            return [2, []];
        });
    });
};
var getJqBuiltInFunctions = function (args) {
    return __awaiter(this, void 0, void 0, function () {
        var isWordToSearchExist, overwriteRange;
        return __generator(this, function (_a) {
            isWordToSearchExist = args.wordToSearch.length ? true : false;
            overwriteRange = vscode_languageserver_types_1.Range.create(vscode_languageserver_types_1.Position.create(args.cursorPosition.line, args.cursorPosition.character - args.wordToSearch.length), vscode_languageserver_types_1.Position.create(args.cursorPosition.line, args.cursorPosition.character));
            return [2, utils_1.jqBuiltInFunctions
                    .filter(function (func) {
                    return !isWordToSearchExist ? true : func.functionName.startsWith(args.wordToSearch);
                })
                    .map(function (filteredFunc) {
                    return (0, channel_1.createCompletionItem)(__assign(__assign({}, args), { completion: filteredFunc.functionName, kind: vscode_languageserver_types_1.CompletionItemKind.Function, label: filteredFunc.functionName, detail: filteredFunc.description, filterText: isWordToSearchExist ? args.wordToSearch : filteredFunc.functionName, extraOptions: {
                            insertText: filteredFunc.functionName,
                        }, overwriteRange: overwriteRange }));
                })];
        });
    });
};
function getJqFunctionCompletions(args) {
    return __awaiter(this, void 0, void 0, function () {
        var currentNode, cursorOffset, offset, isCurrentNodeValueWithQuotes, currentCursor, slicedValue, inputVariableMatch, wordToSearch_1, _a, wordToSearch;
        var _b;
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0:
                    currentNode = args.currentNode, cursorOffset = args.cursorOffset, offset = args.currentNode.offset;
                    isCurrentNodeValueWithQuotes = currentNode.length === currentNode.value.length ? 0 : 1;
                    currentCursor = cursorOffset - offset;
                    slicedValue = currentNode.value.slice(0, currentCursor - isCurrentNodeValueWithQuotes);
                    inputVariableMatch = slicedValue.match(/.*((\.)|(fn:))(\w+)?$/);
                    if (!inputVariableMatch) return [3, 5];
                    wordToSearch_1 = (_b = inputVariableMatch[4]) !== null && _b !== void 0 ? _b : "";
                    if (!(inputVariableMatch[1] === ".")) return [3, 2];
                    return [4, getJqInputVariablesCompletions(__assign(__assign({}, args), { wordToSearch: wordToSearch_1 }))];
                case 1:
                    _a = _c.sent();
                    return [3, 4];
                case 2: return [4, getReusableFunctionCompletion(__assign(__assign({}, args), { wordToSearch: wordToSearch_1 }))];
                case 3:
                    _a = _c.sent();
                    _c.label = 4;
                case 4: return [2, _a];
                case 5:
                    wordToSearch = getJqCompletionWordToSearch(slicedValue);
                    return [4, getJqBuiltInFunctions(__assign(__assign({}, args), { wordToSearch: wordToSearch }))];
                case 6: return [2, _c.sent()];
            }
        });
    });
}
exports.SwfLanguageServiceCodeCompletion = {
    getEmptyFileCodeCompletions: function (args) {
        var kind = vscode_languageserver_types_1.CompletionItemKind.Text;
        var emptyWorkflowLabel = "Empty Serverless Workflow";
        var exampleWorkflowLabel = "Serverless Workflow Example";
        return Promise.resolve([
            {
                kind: kind,
                label: exampleWorkflowLabel,
                detail: "Start with a simple Serverless Workflow",
                sortText: "100_".concat(exampleWorkflowLabel),
                textEdit: {
                    newText: args.codeCompletionStrategy.translate(__assign(__assign({}, args), { completion: code_completions_1.workflowCompletion, completionItemKind: kind })),
                    range: vscode_languageserver_types_1.Range.create(args.cursorPosition, args.cursorPosition),
                },
                insertTextFormat: vscode_languageserver_types_1.InsertTextFormat.Snippet,
            },
            {
                kind: kind,
                label: emptyWorkflowLabel,
                detail: "Start with an empty Serverless Workflow",
                sortText: "100_".concat(emptyWorkflowLabel),
                textEdit: {
                    newText: args.codeCompletionStrategy.translate(__assign(__assign({}, args), { completion: code_completions_1.emptyWorkflowCompletion, completionItemKind: kind })),
                    range: vscode_languageserver_types_1.Range.create(args.cursorPosition, args.cursorPosition),
                },
                insertTextFormat: vscode_languageserver_types_1.InsertTextFormat.Snippet,
            },
        ]);
    },
    getEventsCompletions: function (args) { return __awaiter(void 0, void 0, void 0, function () {
        var kind, existingEventNames, specsDir, result, genericEventCompletion;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    kind = vscode_languageserver_types_1.CompletionItemKind.Interface;
                    existingEventNames = swfModelQueries.getEvents(args.rootNode).map(function (f) { return f.name; });
                    return [4, args.langServiceConfig.getSpecsDirPosixPaths(args.document)];
                case 1:
                    specsDir = _a.sent();
                    result = args.swfCompletionItemServiceCatalogServices.flatMap(function (swfServiceCatalogService) {
                        var dirRelativePosixPath = specsDir.specsDirRelativePosixPath;
                        return swfServiceCatalogService.events
                            .filter(function (swfServiceCatalogEvent) {
                            return swfServiceCatalogEvent.name && !existingEventNames.includes(swfServiceCatalogEvent.name);
                        })
                            .map(function (swfServiceCatalogEvent) {
                            var swfEvent = {
                                name: "${1:".concat(swfServiceCatalogEvent.name, "}"),
                                source: swfServiceCatalogEvent.eventSource,
                                type: swfServiceCatalogEvent.eventType,
                                kind: swfServiceCatalogEvent.kind,
                                metadata: swfServiceCatalogEvent.metadata,
                            };
                            var command = {
                                name: "swf.ls.commands.ImportEventFromCompletionItem",
                                args: {
                                    containingService: swfServiceCatalogService,
                                    documentUri: args.document.uri,
                                },
                            };
                            var kind = swfServiceCatalogEvent.source.type === api_1.SwfCatalogSourceType.SERVICE_REGISTRY
                                ? vscode_languageserver_types_1.CompletionItemKind.Interface
                                : vscode_languageserver_types_1.CompletionItemKind.Reference;
                            var label = args.codeCompletionStrategy.formatLabel(toCompletionItemLabelPrefix(swfServiceCatalogEvent, dirRelativePosixPath), kind);
                            return (0, channel_1.createCompletionItem)(__assign(__assign({}, args), { completion: swfEvent, kind: kind, label: label, detail: swfServiceCatalogService.source.type === api_1.SwfCatalogSourceType.SERVICE_REGISTRY
                                    ? swfServiceCatalogService.source.url
                                    : swfServiceCatalogEvent.operation, extraOptions: {
                                    command: {
                                        command: command.name,
                                        title: "Import event from completion item",
                                        arguments: [command.args],
                                    },
                                } }));
                        });
                    });
                    genericEventCompletion = (0, channel_1.createCompletionItem)(__assign(__assign({}, args), { completion: code_completions_1.eventCompletion, kind: kind, label: "New event", detail: "Add a new event" }));
                    return [2, Promise.resolve(__spreadArray(__spreadArray([], __read(result), false), [genericEventCompletion], false))];
            }
        });
    }); },
    getStatesCompletions: function (args) { return __awaiter(void 0, void 0, void 0, function () {
        var kind;
        return __generator(this, function (_a) {
            kind = vscode_languageserver_types_1.CompletionItemKind.Interface;
            return [2, Promise.resolve([
                    (0, channel_1.createCompletionItem)(__assign(__assign({}, args), { completion: code_completions_1.operationStateCompletion, kind: kind, label: "New operation state", detail: "Add a new operation state" })),
                    (0, channel_1.createCompletionItem)(__assign(__assign({}, args), { completion: code_completions_1.eventStateCompletion, kind: kind, label: "New event state", detail: "Add a new event state" })),
                    (0, channel_1.createCompletionItem)(__assign(__assign({}, args), { completion: code_completions_1.switchStateCompletion, kind: kind, label: "New switch state", detail: "Add a new switch state" })),
                    (0, channel_1.createCompletionItem)(__assign(__assign({}, args), { completion: code_completions_1.injectStateCompletion, kind: kind, label: "New inject state", detail: "Add a new inject state" })),
                ])];
        });
    }); },
    getFunctionCompletions: function (args) { return __awaiter(void 0, void 0, void 0, function () {
        var existingFunctionOperations, specsDir, routesDir, result, genericFunctionCompletion;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    existingFunctionOperations = swfModelQueries.getFunctions(args.rootNode).map(function (f) { return f.operation; });
                    return [4, args.langServiceConfig.getSpecsDirPosixPaths(args.document)];
                case 1:
                    specsDir = _a.sent();
                    return [4, args.langServiceConfig.getRoutesDirPosixPaths(args.document)];
                case 2:
                    routesDir = _a.sent();
                    result = args.swfCompletionItemServiceCatalogServices.flatMap(function (swfServiceCatalogService) {
                        var dirRelativePosixPath;
                        if (swfServiceCatalogService.type === api_1.SwfServiceCatalogServiceType.camelroute) {
                            dirRelativePosixPath = routesDir.routesDirRelativePosixPath;
                        }
                        else {
                            dirRelativePosixPath = specsDir.specsDirRelativePosixPath;
                        }
                        return swfServiceCatalogService.functions
                            .filter(function (swfServiceCatalogFunc) {
                            return swfServiceCatalogFunc.name && !existingFunctionOperations.includes(swfServiceCatalogFunc.operation);
                        })
                            .map(function (swfServiceCatalogFunc) {
                            var swfFunction = {
                                name: "${1:".concat(swfServiceCatalogFunc.name, "}"),
                                operation: swfServiceCatalogFunc.operation,
                                type: swfServiceCatalogFunc.type,
                            };
                            var command = {
                                name: "swf.ls.commands.ImportFunctionFromCompletionItem",
                                args: {
                                    containingService: swfServiceCatalogService,
                                    documentUri: args.document.uri,
                                },
                            };
                            var kind = swfServiceCatalogFunc.source.type === api_1.SwfCatalogSourceType.SERVICE_REGISTRY
                                ? vscode_languageserver_types_1.CompletionItemKind.Interface
                                : vscode_languageserver_types_1.CompletionItemKind.Reference;
                            var label = args.codeCompletionStrategy.formatLabel(toCompletionItemLabelPrefix(swfServiceCatalogFunc, dirRelativePosixPath), kind);
                            return (0, channel_1.createCompletionItem)(__assign(__assign({}, args), { completion: swfFunction, kind: kind, label: label, detail: swfServiceCatalogService.source.type === api_1.SwfCatalogSourceType.SERVICE_REGISTRY
                                    ? swfServiceCatalogService.source.url
                                    : swfServiceCatalogFunc.operation, extraOptions: {
                                    command: {
                                        command: command.name,
                                        title: "Import function from completion item",
                                        arguments: [command.args],
                                    },
                                } }));
                        });
                    });
                    genericFunctionCompletion = (0, channel_1.createCompletionItem)(__assign(__assign({}, args), { completion: code_completions_1.functionCompletion, kind: vscode_languageserver_types_1.CompletionItemKind.Interface, label: "New function", detail: "Add a new function" }));
                    return [2, Promise.resolve(__spreadArray(__spreadArray([], __read(result), false), [genericFunctionCompletion], false))];
            }
        });
    }); },
    getFunctionOperationCompletions: function (args) { return __awaiter(void 0, void 0, void 0, function () {
        var isRestFunction, isExpression, _a, _b, existingFunctionOperations, result;
        var _c, _d, _e, _f;
        return __generator(this, function (_g) {
            switch (_g.label) {
                case 0:
                    if (!((_c = args.currentNode.parent) === null || _c === void 0 ? void 0 : _c.parent)) {
                        return [2, Promise.resolve([])];
                    }
                    isRestFunction = ((_e = (_d = (0, channel_1.findNodeAtLocation)(args.currentNode.parent.parent, ["type"])) === null || _d === void 0 ? void 0 : _d.value) !== null && _e !== void 0 ? _e : "rest") === "rest";
                    isExpression = ((_f = (0, channel_1.findNodeAtLocation)(args.currentNode.parent.parent, ["type"])) === null || _f === void 0 ? void 0 : _f.value) === "expression";
                    if (!isRestFunction && !isExpression) {
                        return [2, Promise.resolve([])];
                    }
                    if (!isExpression) return [3, 2];
                    _b = (_a = Promise).resolve;
                    return [4, getJqFunctionCompletions(args)];
                case 1: return [2, _b.apply(_a, [_g.sent()])];
                case 2:
                    existingFunctionOperations = swfModelQueries.getFunctions(args.rootNode).map(function (f) { return f.operation; });
                    result = args.swfCompletionItemServiceCatalogServices
                        .flatMap(function (s) { return s.functions; })
                        .filter(function (swfServiceCatalogFunc) { return !existingFunctionOperations.includes(swfServiceCatalogFunc.operation); })
                        .map(function (swfServiceCatalogFunc) {
                        var kind = swfServiceCatalogFunc.source.type === api_1.SwfCatalogSourceType.SERVICE_REGISTRY
                            ? vscode_languageserver_types_1.CompletionItemKind.Function
                            : vscode_languageserver_types_1.CompletionItemKind.Folder;
                        var label = args.codeCompletionStrategy.formatLabel(swfServiceCatalogFunc.operation, kind);
                        return (0, channel_1.createCompletionItem)(__assign(__assign({}, args), { completion: "".concat(swfServiceCatalogFunc.operation), kind: kind, label: label, detail: label }));
                    });
                    return [2, Promise.resolve(result)];
            }
        });
    }); },
    getFunctionRefCompletions: function (args) {
        if (args.currentNode.type !== "property") {
            console.debug("Cannot autocomplete: functionRef should be a property.");
            return Promise.resolve([]);
        }
        var result = swfModelQueries.getFunctions(args.rootNode).flatMap(function (swfFunction) {
            var swfServiceCatalogFunc = args.swfCompletionItemServiceCatalogServices
                .flatMap(function (f) { return f.functions; })
                .filter(function (f) { return f.operation === swfFunction.operation; })
                .pop();
            if (!swfServiceCatalogFunc) {
                return [];
            }
            var argIndex = 1;
            var swfFunctionRefArgs = {};
            Object.keys(swfServiceCatalogFunc.arguments).forEach(function (argName) {
                swfFunctionRefArgs[argName] = "${".concat(argIndex++, ":}");
            });
            var swfFunctionRef = {
                refName: swfFunction.name,
                arguments: swfFunctionRefArgs,
            };
            var kind = vscode_languageserver_types_1.CompletionItemKind.Module;
            var label = args.codeCompletionStrategy.formatLabel(swfFunctionRef.refName, kind);
            return [
                (0, channel_1.createCompletionItem)(__assign(__assign({}, args), { completion: swfFunctionRef, kind: kind, label: label, detail: "".concat(swfServiceCatalogFunc.operation) })),
            ];
        });
        return Promise.resolve(result);
    },
    getFunctionRefRefnameCompletions: function (args) {
        var result = swfModelQueries.getFunctions(args.rootNode).flatMap(function (swfFunction) {
            var kind = vscode_languageserver_types_1.CompletionItemKind.Value;
            var label = args.codeCompletionStrategy.formatLabel(swfFunction.name, kind);
            return [
                (0, channel_1.createCompletionItem)(__assign(__assign({}, args), { completion: "".concat(swfFunction.name), kind: kind, label: label, detail: "\"".concat(swfFunction.name, "\"") })),
            ];
        });
        return Promise.resolve(result);
    },
    getFunctionRefArgumentsCompletions: function (args) {
        var _a, _b;
        if (args.currentNode.type !== "property" && args.currentNode.type !== "string") {
            console.debug("Cannot autocomplete: arguments should be a property.");
            return Promise.resolve([]);
        }
        var startNode = (0, channel_1.nodeUpUntilType)(args.currentNode, "object");
        if (!startNode) {
            return Promise.resolve([]);
        }
        var swfFunctionRefName = (_a = (0, channel_1.findNodeAtLocation)(startNode, ["refName"])) === null || _a === void 0 ? void 0 : _a.value;
        if (!swfFunctionRefName) {
            return Promise.resolve([]);
        }
        var swfFunction = (_b = swfModelQueries
            .getFunctions(args.rootNode)) === null || _b === void 0 ? void 0 : _b.filter(function (f) { return f.name === swfFunctionRefName; }).pop();
        if (!swfFunction) {
            return Promise.resolve([]);
        }
        var swfServiceCatalogFunc = args.swfCompletionItemServiceCatalogServices
            .flatMap(function (f) { return f.functions; })
            .filter(function (f) { return f.operation === swfFunction.operation; })
            .pop();
        if (!swfServiceCatalogFunc) {
            return Promise.resolve([]);
        }
        var argIndex = 1;
        var swfFunctionRefArgs = {};
        Object.keys(swfServiceCatalogFunc.arguments).forEach(function (argName) {
            swfFunctionRefArgs[argName] = "${".concat(argIndex++, ":}");
        });
        var kind = vscode_languageserver_types_1.CompletionItemKind.Module;
        var label = "'".concat(swfFunctionRefName, "' arguments");
        return Promise.resolve([
            (0, channel_1.createCompletionItem)(__assign(__assign({}, args), { completion: swfFunctionRefArgs, kind: kind, label: label, detail: swfFunction.operation })),
        ]);
    },
    getEventRefsCompletions: function (args) {
        var result = swfModelQueries.getEvents(args.rootNode).flatMap(function (event) {
            var kind = vscode_languageserver_types_1.CompletionItemKind.Value;
            var label = args.codeCompletionStrategy.formatLabel(event.name, kind);
            return [
                (0, channel_1.createCompletionItem)(__assign(__assign({}, args), { completion: "".concat(event.name), kind: kind, label: label, detail: "\"".concat(event.name, "\"") })),
            ];
        });
        return Promise.resolve(result);
    },
    getTransitionCompletions: function (args) {
        var _a;
        var statePath = (0, channel_1.getNodePath)(args.currentNode).slice(0, 2);
        var currentStateName = ((_a = (0, channel_1.findNodeAtLocation)(args.rootNode, __spreadArray(__spreadArray([], __read(statePath), false), ["name"], false))) === null || _a === void 0 ? void 0 : _a.value) || "";
        var states = swfModelQueries
            .getStates(args.rootNode)
            .filter(function (s) { return s.name !== currentStateName; });
        var result = getStateNameCompletion(__assign(__assign({}, args), { states: states }));
        return Promise.resolve(result);
    },
    getStartCompletions: function (args) {
        var states = swfModelQueries.getStates(args.rootNode);
        var result = getStateNameCompletion(__assign(__assign({}, args), { states: states }));
        return Promise.resolve(result);
    },
    getJqcompletions: function (args) { return __awaiter(void 0, void 0, void 0, function () {
        var jqCompletions;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4, getJqFunctionCompletions(args)];
                case 1:
                    jqCompletions = _a.sent();
                    if (args.currentNode && args.currentNode.type === "string") {
                        return [2, Promise.resolve(jqCompletions)];
                    }
                    return [2, Promise.resolve([])];
            }
        });
    }); },
};
//# sourceMappingURL=SwfLanguageServiceCodeCompletion.js.map