"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.injectStateCompletion = exports.switchStateCompletion = exports.eventStateCompletion = exports.operationStateCompletion = exports.genericStateCompletion = void 0;
exports.genericStateCompletion = {
    name: "${1:Unique State name}",
    transition: "${10:Next transition of the workflow}",
};
exports.operationStateCompletion = {
    name: exports.genericStateCompletion.name,
    type: "operation",
    actions: [
        {
            name: "${5:Unique Action name}",
            functionRef: {},
        },
    ],
    transition: exports.genericStateCompletion.transition,
    end: false,
};
exports.eventStateCompletion = {
    name: exports.genericStateCompletion.name,
    type: "event",
    onEvents: [
        {
            eventRefs: ["${5:Unique event names}"],
        },
    ],
    transition: exports.genericStateCompletion.transition,
    end: false,
};
exports.switchStateCompletion = {
    name: exports.genericStateCompletion.name,
    type: "switch",
    dataConditions: [
        {
            condition: "${5:Workflow expression evaluated against state data}",
            transition: "${6:Transition to another state if condition is true}",
        },
    ],
    defaultCondition: {
        transition: "${7:Default transition of the workflow}",
    },
};
exports.injectStateCompletion = {
    name: exports.genericStateCompletion.name,
    type: "inject",
    data: {},
    transition: exports.genericStateCompletion.transition,
    end: false,
};
//# sourceMappingURL=states-completions.js.map