import { getInstanceNs, domParser, getParser } from "@kie-tools/xml-parser-ts";
import { meta as bpmn20meta, elements as bpmn20elements, subs as bpmn20subs, root as bpmn20root, ns as bpmn20ns, } from "./schemas/bpmn-2_0/ts-gen/meta";
export function getMarshaller(xml) {
    const domdoc = domParser.getDomDocument(xml);
    const instanceNs = getInstanceNs(domdoc);
    const p = getParser({
        ns: bpmn20ns,
        meta: bpmn20meta,
        subs: bpmn20subs,
        elements: bpmn20elements,
        root: bpmn20root,
    });
    return {
        instanceNs,
        version: "2.0",
        root: bpmn20root,
        meta: bpmn20meta,
        parser: { parse: () => p.parse({ type: "domdoc", domdoc, instanceNs }).json },
        builder: { build: (json) => p.build({ json, instanceNs }) },
    };
}
//# sourceMappingURL=index.js.map