export default class WorkflowListEnvelopeViewDriver {
    constructor(channelApi) {
        this.channelApi = channelApi;
    }
    initialLoad(filter, sortBy) {
        return this.channelApi.requests.workflowList__initialLoad(filter, sortBy);
    }
    openWorkflow(workflow) {
        return this.channelApi.requests.workflowList__openWorkflow(workflow);
    }
    applyFilter(filter) {
        return this.channelApi.requests.workflowList__applyFilter(filter);
    }
    applySorting(sortBy) {
        return this.channelApi.requests.workflowList__applySorting(sortBy);
    }
    handleWorkflowSkip(workflowInstance) {
        return this.channelApi.requests.workflowList__handleWorkflowSkip(workflowInstance);
    }
    handleWorkflowRetry(workflowInstance) {
        return this.channelApi.requests.workflowList__handleWorkflowRetry(workflowInstance);
    }
    handleWorkflowAbort(workflowInstance) {
        return this.channelApi.requests.workflowList__handleWorkflowAbort(workflowInstance);
    }
    handleWorkflowMultipleAction(workflowInstances, operationType) {
        return this.channelApi.requests.workflowList__handleWorkflowMultipleAction(workflowInstances, operationType);
    }
    query(offset, limit) {
        return this.channelApi.requests.workflowList__query(offset, limit);
    }
    getChildWorkflowsQuery(rootWorkflowInstanceId) {
        return this.channelApi.requests.workflowList__getChildWorkflowsQuery(rootWorkflowInstanceId);
    }
    openTriggerCloudEvent(workflowInstance) {
        this.channelApi.notifications.workflowList__openTriggerCloudEvent.send(workflowInstance);
    }
}
//# sourceMappingURL=WorkflowListEnvelopeViewDriver.js.map