import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useCallback, useEffect, useMemo, useRef, useState } from "react";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { ActionListGroup } from "@patternfly/react-core/dist/js/components/ActionList";
import { Select, SelectOption, SelectVariant } from "@patternfly/react-core/dist/js/components/Select";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Form, FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { InputGroup } from "@patternfly/react-core/dist/js/components/InputGroup";
import { ValidatedOptions } from "@patternfly/react-core/dist/js/helpers";
import ExclamationCircleIcon from "@patternfly/react-icons/dist/esm/icons/exclamation-circle-icon";
import { validateCloudEventRequest } from "./validateCloudEventRequest";
import CloudEventCustomHeadersEditor from "../CloudEventCustomHeadersEditor/CloudEventCustomHeadersEditor";
import CloudEventFieldLabelIcon from "../CloudEventFieldLabelIcon/CloudEventFieldLabelIcon";
import { RequestDataEditor, } from "@kie-tools/runtime-tools-components/dist/components/RequestDataEditor";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { CloudEventMethod } from "@kie-tools/runtime-tools-swf-gateway-api/dist/types";
import { KOGITO_BUSINESS_KEY, KOGITO_PROCESS_REFERENCE_ID, } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
export const CloudEventForm = ({ driver, serviceUrl, isNewInstanceEvent, defaultValues, ouiaId, ouiaSafe, }) => {
    const [validationState, setValidationState] = useState();
    const customHeadersEditorApi = useRef(null);
    const requestDataEditorRef = useRef(null);
    const [isMethodOpen, setIsMethodOpen] = useState(false);
    const [method, setMethod] = useState(CloudEventMethod.POST);
    const [endpoint, setEndpoint] = useState("/");
    const [instanceId, setInstanceId] = useState("");
    const [businessKey, setBusinessKey] = useState("");
    const [eventType, setEventType] = useState("");
    const [eventSource, setEventSource] = useState("/from/form");
    const [eventData, setEventData] = useState("");
    const [isLoading, setIsLoading] = useState(false);
    const resetForm = useCallback(() => {
        var _a, _b, _c, _d;
        setMethod(CloudEventMethod.POST);
        setEndpoint("/");
        setEventType("");
        setEventSource((_a = defaultValues === null || defaultValues === void 0 ? void 0 : defaultValues.cloudEventSource) !== null && _a !== void 0 ? _a : "/from/form");
        setEventData("");
        setInstanceId((_b = defaultValues === null || defaultValues === void 0 ? void 0 : defaultValues.instanceId) !== null && _b !== void 0 ? _b : "");
        setBusinessKey("");
        (_c = customHeadersEditorApi === null || customHeadersEditorApi === void 0 ? void 0 : customHeadersEditorApi.current) === null || _c === void 0 ? void 0 : _c.reset();
        (_d = requestDataEditorRef.current) === null || _d === void 0 ? void 0 : _d.setContent("");
    }, [defaultValues]);
    useEffect(() => {
        var _a, _b;
        setEventSource((_a = defaultValues === null || defaultValues === void 0 ? void 0 : defaultValues.cloudEventSource) !== null && _a !== void 0 ? _a : "/from/form");
        setInstanceId((_b = defaultValues === null || defaultValues === void 0 ? void 0 : defaultValues.instanceId) !== null && _b !== void 0 ? _b : "");
    }, [defaultValues]);
    const getValidatedOption = useCallback((fieldId) => {
        return getValidationMessage(fieldId) ? ValidatedOptions.error : ValidatedOptions.default;
    }, [validationState]);
    const getValidationMessage = useCallback((fieldId) => {
        return validationState && validationState.getFieldValidation(fieldId);
    }, [validationState]);
    const doTrigger = useCallback(() => {
        var _a;
        const extensions = {
            ...(_a = customHeadersEditorApi === null || customHeadersEditorApi === void 0 ? void 0 : customHeadersEditorApi.current) === null || _a === void 0 ? void 0 : _a.getCustomHeaders(),
        };
        if (isNewInstanceEvent) {
            businessKey && (extensions[KOGITO_BUSINESS_KEY] = businessKey);
        }
        else {
            instanceId && (extensions[KOGITO_PROCESS_REFERENCE_ID] = instanceId);
        }
        const eventRequest = {
            endpoint: endpoint,
            method: method,
            data: eventData,
            headers: {
                type: eventType,
                source: eventSource,
                extensions,
            },
            serviceUrl: serviceUrl,
        };
        const validations = validateCloudEventRequest(eventRequest);
        setValidationState(validations);
        if (!validations.isValid()) {
            return;
        }
        setIsLoading(true);
        driver
            .triggerCloudEvent(eventRequest)
            .then((response) => {
            resetForm();
        })
            .finally(() => {
            setIsLoading(false);
        });
    }, [method, endpoint, eventType, eventSource, eventData, instanceId, businessKey]);
    const requestDataEditor = useMemo(() => {
        return (_jsx(RequestDataEditor, { ref: requestDataEditorRef, content: "", onContentChange: (args) => setEventData(args.content), isReadOnly: false }));
    }, [setEventData]);
    if (isLoading) {
        return (_jsx(Bullseye, { children: _jsx(KogitoSpinner, { spinnerText: "Triggering cloud event...", ouiaId: "cloud-event-form-loading" }) }));
    }
    return (_jsx("div", { ...componentOuiaProps(ouiaId, "workflow-form", ouiaSafe), children: _jsxs(Form, { isHorizontal: true, children: [_jsx(FormGroup, { label: "Event Endpoint", isRequired: true, fieldId: "endpoint", helperTextInvalid: getValidationMessage("endpoint"), helperTextInvalidIcon: _jsx(ExclamationCircleIcon, {}), validated: getValidatedOption("endpoint"), labelIcon: _jsx(CloudEventFieldLabelIcon, { fieldId: "endpoint", helpMessage: "Sets the endpoint and method where the CloudEvent should be triggered." }), children: _jsxs(InputGroup, { children: [_jsxs(Select, { id: "method", width: "100px", variant: SelectVariant.single, selections: method, onSelect: (event, value) => {
                                    var _a;
                                    setMethod((_a = CloudEventMethod[value]) !== null && _a !== void 0 ? _a : CloudEventMethod.POST);
                                    setIsMethodOpen(false);
                                }, isOpen: isMethodOpen, onToggle: () => setIsMethodOpen(!isMethodOpen), children: [_jsx(SelectOption, { value: CloudEventMethod.POST }), _jsx(SelectOption, { value: CloudEventMethod.PUT })] }), _jsx(TextInput, { id: "endpoint", isRequired: true, value: endpoint, onChange: setEndpoint, validated: getValidatedOption("endpoint") })] }) }), _jsx(FormGroup, { label: "Event Type", isRequired: true, fieldId: "eventType", helperTextInvalid: getValidationMessage("eventType"), helperTextInvalidIcon: _jsx(ExclamationCircleIcon, {}), validated: getValidatedOption("eventType"), labelIcon: _jsx(CloudEventFieldLabelIcon, { fieldId: "eventType", helpMessage: "Sets the type of the cloud event.", cloudEventHeader: "type" }), children: _jsx(TextInput, { value: eventType, isRequired: true, type: "text", id: "eventType", onChange: setEventType, validated: getValidatedOption("eventType") }) }), _jsx(FormGroup, { label: "Event Source", labelIcon: _jsx(CloudEventFieldLabelIcon, { fieldId: "eventSource", helpMessage: "Sets the source of the cloud event.", cloudEventHeader: "source" }), fieldId: "eventSource", children: _jsx(TextInput, { value: eventSource, isRequired: true, type: "text", id: "eventSource", onChange: setEventSource }) }), !isNewInstanceEvent && (_jsx(FormGroup, { label: "Instance Id", fieldId: "instanceId", labelIcon: _jsx(CloudEventFieldLabelIcon, { fieldId: "instanceId", helpMessage: "Sets the Service Workflow instance Id the cloud event will interact with.", cloudEventHeader: "kogitoprocrefid" }), children: _jsx(TextInput, { value: instanceId, isRequired: true, type: "text", id: "instanceId", onChange: setInstanceId }) })), isNewInstanceEvent && (_jsx(FormGroup, { label: "Business Key", fieldId: "businessKey", labelIcon: _jsx(CloudEventFieldLabelIcon, { fieldId: "businessKey", helpMessage: "Sets the Business Key for the Serverless Workflow instance started by the cloud event.", cloudEventHeader: "kogitobusinesskey" }), children: _jsx(TextInput, { value: businessKey, isRequired: true, type: "text", id: "businessKey", onChange: setBusinessKey }) })), _jsx(FormGroup, { label: "Event Custom Headers", fieldId: "customHeaders", labelIcon: _jsx(CloudEventFieldLabelIcon, { fieldId: "customHeaders", helpMessage: _jsxs("div", { children: [_jsx("p", { children: "Sets the custom headers that will be added into the Cloud Event." }), _jsxs("p", { children: ["Press the ", _jsx("span", { className: "pf-u-link-color", children: "Add Header" }), " button to start adding new headers."] }), _jsx("p", { children: "Headers with empty Name won't be added into the Cloud Event." })] }) }), children: _jsx(CloudEventCustomHeadersEditor, { ref: customHeadersEditorApi }) }), _jsx(FormGroup, { label: "Event Data", fieldId: "eventData", isHelperTextBeforeField: true, helperTextInvalid: getValidationMessage("eventData"), helperTextInvalidIcon: _jsx(ExclamationCircleIcon, {}), validated: getValidatedOption("eventData"), labelIcon: _jsx(CloudEventFieldLabelIcon, { fieldId: "eventData", helpMessage: "Sets the content of the cloud event in JSON format." }), children: requestDataEditor }), _jsxs(ActionListGroup, { children: [_jsx(Button, { variant: "primary", onClick: doTrigger, children: "Trigger" }, "triggerCloudEventButton"), _jsx(Button, { variant: "secondary", onClick: resetForm, children: "Reset" }, "resetCloudEventFormButton")] })] }) }));
};
export default CloudEventForm;
//# sourceMappingURL=CloudEventForm.js.map