"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseAsyncApi = parseAsyncApi;
exports.extractFunctions = extractFunctions;
exports.extractEvents = extractEvents;
var api_1 = require("../../../../api");
var convertSource_1 = require("../convertSource");
function parseAsyncApi(args, serviceAsyncApiDocument) {
    var _a;
    var swfServiceCatalogFunctions = extractFunctions(serviceAsyncApiDocument, (0, convertSource_1.convertSource)(args.source));
    var swfServiceCatalogEvents = extractEvents(serviceAsyncApiDocument, (0, convertSource_1.convertSource)(args.source));
    return {
        name: (_a = serviceAsyncApiDocument.info.title) !== null && _a !== void 0 ? _a : args.serviceFileName,
        type: api_1.SwfServiceCatalogServiceType.asyncapi,
        source: args.source,
        functions: swfServiceCatalogFunctions,
        events: swfServiceCatalogEvents,
        rawContent: args.serviceFileContent,
    };
}
function extractFunctions(serviceAsyncApiDocument, source) {
    var swfServiceCatalogFunctions = Object.entries(serviceAsyncApiDocument.channels).map(function (_a) {
        var _b = __read(_a, 2), endpoint = _b[0], channelItem = _b[1];
        return extractChannelItemFunctions(channelItem, endpoint, serviceAsyncApiDocument, source);
    });
    return [].concat.apply([], swfServiceCatalogFunctions);
}
function extractChannelItemFunctions(channelItem, endpoint, serviceAsyncApiDocument, source) {
    var swfServiceCatalogFunctions = [];
    var functionArguments = {};
    if (channelItem.parameters) {
        extractFunctionArgumentsFromParams(channelItem === null || channelItem === void 0 ? void 0 : channelItem.parameters, functionArguments);
    }
    Object.values(channelItem)
        .filter(function (channelOperation) { return channelOperation.operationId; })
        .forEach(function (channelOperation) {
        var body = channelOperation.message;
        var name = channelOperation.operationId;
        if (body) {
            extractFunctionArgumentsFromRequestBody(body !== null && body !== void 0 ? body : {}, serviceAsyncApiDocument, functionArguments);
        }
        var swfServiceCatalogFunction = {
            source: source,
            name: name,
            type: api_1.SwfServiceCatalogFunctionType.asyncapi,
            arguments: functionArguments,
        };
        swfServiceCatalogFunctions.push(swfServiceCatalogFunction);
    });
    return swfServiceCatalogFunctions;
}
function extractFunctionArgumentsFromParams(channelParams, functionParams) {
    var paramNames = Object.keys(channelParams);
    paramNames.forEach(function (paramName) {
        var _a, _b;
        if (channelParams && paramName) {
            functionParams[paramName] = resolveArgumentType((_b = (_a = channelParams[paramName]) === null || _a === void 0 ? void 0 : _a.schema) === null || _b === void 0 ? void 0 : _b.type);
        }
    });
}
function extractFunctionArgumentsFromRequestBody(message, doc, functionParams) {
    var schemaObject = extractMessageObject(message, doc);
    if (schemaObject.properties) {
        Object.entries(schemaObject.properties).forEach(function (_a) {
            var _b = __read(_a, 2), propertyName = _b[0], propertySchema = _b[1];
            var asReference = propertySchema;
            if (asReference.$ref) {
                functionParams[propertyName] = api_1.SwfServiceCatalogFunctionArgumentType.object;
            }
            else {
                var asSchema = propertySchema;
                if (asSchema.type) {
                    functionParams[propertyName] = resolveArgumentType(asSchema.type);
                }
            }
        });
    }
}
function extractMessageObject(message, doc) {
    var _a, _b, _c;
    var asReference = message;
    if (asReference.$ref) {
        var messageRef = (_a = asReference.$ref.split("/").pop()) !== null && _a !== void 0 ? _a : "";
        var resolvedMessage = ((_b = doc.components) === null || _b === void 0 ? void 0 : _b.messages)
            ? (_c = doc.components) === null || _c === void 0 ? void 0 : _c.messages[messageRef]
            : {};
        return extractSchemaObject(resolvedMessage === null || resolvedMessage === void 0 ? void 0 : resolvedMessage.payload, doc);
    }
    return message === null || message === void 0 ? void 0 : message.payload;
}
function extractSchemaObject(payload, doc) {
    var _a, _b, _c;
    var asReference = payload;
    if (asReference.$ref) {
        var schemaRef = (_a = asReference.$ref.split("/").pop()) !== null && _a !== void 0 ? _a : "";
        var resolvedSchema = ((_b = doc.components) === null || _b === void 0 ? void 0 : _b.schemas) ? (_c = doc.components) === null || _c === void 0 ? void 0 : _c.schemas[schemaRef] : {};
        return extractSchemaObject(resolvedSchema, doc);
    }
    return asReference;
}
function resolveArgumentType(type) {
    switch (type) {
        case "boolean":
            return api_1.SwfServiceCatalogFunctionArgumentType.boolean;
        case "object":
            return api_1.SwfServiceCatalogFunctionArgumentType.object;
        case "number":
            return api_1.SwfServiceCatalogFunctionArgumentType.number;
        case "string":
            return api_1.SwfServiceCatalogFunctionArgumentType.string;
        case "integer":
            return api_1.SwfServiceCatalogFunctionArgumentType.integer;
        case "array":
            return api_1.SwfServiceCatalogFunctionArgumentType.array;
    }
    return api_1.SwfServiceCatalogFunctionArgumentType.object;
}
function extractEvents(serviceAsyncApiDocument, source) {
    var swfServiceCatalogEvents = Object.entries(serviceAsyncApiDocument.channels).map(function (_a) {
        var _b = __read(_a, 2), endpoint = _b[0], channelItem = _b[1];
        return extractChannelItemEvents(channelItem, endpoint, serviceAsyncApiDocument, source);
    });
    return [].concat.apply([], swfServiceCatalogEvents);
}
function extractChannelItemEvents(channelItem, endpoint, serviceAsyncApiDocument, source) {
    var swfServiceCatalogEvents = [];
    var eventArguments = {};
    if (channelItem.parameters) {
        extractFunctionArgumentsFromParams(channelItem === null || channelItem === void 0 ? void 0 : channelItem.parameters, eventArguments);
    }
    Object.values(channelItem)
        .filter(function (channelOperation) { return channelOperation.operationId; })
        .forEach(function (channelOperation) {
        var body = channelOperation.message;
        var name = channelOperation.operationId;
        var eventKind;
        var operation = Object.keys(channelItem).find(function (key) { return channelItem[key] === channelOperation; });
        if (operation === "subscribe") {
            eventKind = api_1.SwfServiceCatalogEventKind.CONSUMED;
        }
        else if (operation === "publish") {
            eventKind = api_1.SwfServiceCatalogEventKind.PRODUCED;
        }
        if (body) {
            extractFunctionArgumentsFromRequestBody(body !== null && body !== void 0 ? body : {}, serviceAsyncApiDocument, eventArguments);
        }
        var swfServiceCatalogEvent = {
            source: source,
            name: name,
            type: api_1.SwfServiceCatalogEventType.asyncapi,
            kind: eventKind,
            eventSource: "",
            eventType: "",
        };
        swfServiceCatalogEvents.push(swfServiceCatalogEvent);
    });
    return swfServiceCatalogEvents;
}
//# sourceMappingURL=asyncapi.js.map