export function computeTestScenarioDataObjects(factMappings) {
    var _a, _b, _c, _d, _e, _f;
    const factsMappings = factMappings !== null && factMappings !== void 0 ? factMappings : [];
    const dataObjects = [];
    for (let i = 2; i < factsMappings.length; i++) {
        if (factsMappings[i].className.__$$text === "java.lang.Void") {
            continue;
        }
        const factID = factsMappings[i].expressionElements.ExpressionElement[0].step.__$$text;
        const dataObject = dataObjects.find((value) => value.id === factID);
        const isSimpleTypeFact = factsMappings[i].expressionElements.ExpressionElement.length === 1;
        const isCollection = ((_c = (_b = (_a = factsMappings[i].genericTypes) === null || _a === void 0 ? void 0 : _a.string) === null || _b === void 0 ? void 0 : _b.length) !== null && _c !== void 0 ? _c : 0) > 0;
        const propertyID = isSimpleTypeFact
            ? factsMappings[i].expressionElements.ExpressionElement[0].step.__$$text.concat(".").concat("value")
            : factsMappings[i]
                .expressionElements.ExpressionElement.map((expressionElement) => expressionElement.step.__$$text)
                .join(".");
        const propertyName = isSimpleTypeFact
            ? "value"
            : factsMappings[i].expressionElements.ExpressionElement.slice(-1)[0].step.__$$text;
        const factClassName = (_d = factsMappings[i].factIdentifier.className.__$$text) !== null && _d !== void 0 ? _d : "<Undefined>";
        const propertyClassName = (_e = factsMappings[i].className.__$$text) !== null && _e !== void 0 ? _e : "<Undefined>";
        if (dataObject) {
            if (!((_f = dataObject.children) === null || _f === void 0 ? void 0 : _f.some((value) => value.id === propertyID))) {
                dataObject.children.push({
                    id: propertyID,
                    className: propertyClassName,
                    customBadgeContent: isCollection
                        ? `${factsMappings[i].genericTypes.string[0].__$$text}${isCollection ? "[]" : ""}`
                        : propertyClassName,
                    expressionElements: factsMappings[i].expressionElements.ExpressionElement.map((element) => element.step.__$$text),
                    name: propertyName,
                });
            }
        }
        else {
            dataObjects.push({
                id: factID,
                className: factClassName,
                customBadgeContent: factClassName,
                expressionElements: [factID],
                name: factsMappings[i].factAlias.__$$text,
                children: [
                    {
                        id: propertyID,
                        className: propertyClassName,
                        customBadgeContent: isCollection
                            ? `${factsMappings[i].genericTypes.string[0].__$$text}${isCollection ? "[]" : ""}`
                            : propertyClassName,
                        expressionElements: factsMappings[i].expressionElements.ExpressionElement.map((element) => element.step.__$$text),
                        name: propertyName,
                    },
                ],
            });
        }
    }
    return dataObjects;
}
//# sourceMappingURL=computeTestScenarioDataObjects.js.map