import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Children, cloneElement, isValidElement } from "react";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import { OutlinedQuestionCircleIcon } from "@patternfly/react-icons/dist/js/icons/outlined-question-circle-icon";
import { connectField, filterDOMProps } from "uniforms";
import ListItemField from "./ListItemField";
import ListAddField from "./ListAddField";
filterDOMProps.register("minCount", "wrapperCol", "labelCol");
function ListField({ children = _jsx(ListItemField, { name: "$" }), error, errorMessage, info, initialCount, itemProps, label, name, value, showInlineError, ...props }) {
    return (_jsxs("div", { "data-testid": "list-field", ...filterDOMProps(props), children: [_jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { children: label && (_jsxs("label", { children: [label, !!info && (_jsxs("span", { children: ["\u00A0", _jsx(Tooltip, { content: info, children: _jsx(OutlinedQuestionCircleIcon, {}) })] }))] })) }), _jsx(SplitItem, { isFilled: true }), _jsx(SplitItem, { children: _jsx(ListAddField, { name: "$", initialCount: initialCount }) })] }), _jsx("div", { children: value === null || value === void 0 ? void 0 : value.map((item, itemIndex) => Children.map(children, (child, childIndex) => {
                    var _a;
                    return isValidElement(child)
                        ? cloneElement(child, {
                            key: `${itemIndex}-${childIndex}`,
                            name: (_a = child.props.name) === null || _a === void 0 ? void 0 : _a.split(/\$([\s\S]*)/).slice(0, -1).join(`${itemIndex}`),
                            ...itemProps,
                        })
                        : child;
                })) })] }));
}
export default connectField(ListField);
//# sourceMappingURL=ListField.js.map