import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useForm, filterDOMProps } from "uniforms";
function ErrorsField({ children, ...props }) {
    const { error, schema } = useForm();
    return !error && !children ? null : (_jsxs("div", { "data-testid": "errors-field", ...filterDOMProps(props), children: [children, _jsx("ul", { children: schema.getErrorMessages(error).map((message, index) => (_jsx("li", { style: { margin: "3px" }, children: message }, index))) })] }));
}
ErrorsField.defaultProps = {
    style: {
        backgroundColor: "rgba(255, 85, 0, 0.2)",
        border: "1px solid rgb(255, 85, 0)",
        borderRadius: "7px",
        margin: "20px 0px",
        padding: "10px",
    },
};
export default ErrorsField;
//# sourceMappingURL=ErrorsField.js.map