"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.jbpmBootstrap4FormCodeGeneratorTheme = void 0;
var dist_1 = require("@kie-tools/form-code-generator-bootstrap4-theme/dist");
var theme_1 = require("@kie-tools/form-code-generator-bootstrap4-theme/dist/theme");
var unescape_1 = __importDefault(require("lodash/unescape"));
var uniforms_bridge_json_schema_1 = __importDefault(require("uniforms-bridge-json-schema"));
var getUniformsSchema_1 = require("./getUniformsSchema");
var removeInvalidVarChars_1 = require("./removeInvalidVarChars");
exports.jbpmBootstrap4FormCodeGeneratorTheme = {
    generate: function (formSchema) {
        var uniformsSchema = (0, getUniformsSchema_1.getUniformsSchema)(formSchema.schema);
        var form = (0, dist_1.renderForm)({
            id: formSchema.name,
            idWithoutInvalidTsVarChars: (0, removeInvalidVarChars_1.removeInvalidVarChars)(formSchema.name),
            schema: new uniforms_bridge_json_schema_1.default(uniformsSchema, function () { return true; }),
            disabled: false,
            placeholder: true,
        });
        return {
            name: formSchema.name,
            nameWithoutInvalidTsVarChars: (0, removeInvalidVarChars_1.removeInvalidVarChars)(formSchema.name),
            fileName: "".concat(formSchema.name, ".").concat(theme_1.BOOTSTRAP4_FILE_EXT),
            fileNameWithoutInvalidVarChars: "".concat((0, removeInvalidVarChars_1.removeInvalidVarChars)(formSchema.name), ".").concat(theme_1.BOOTSTRAP4_FILE_EXT),
            fileExt: theme_1.BOOTSTRAP4_FILE_EXT,
            content: (0, unescape_1.default)(form),
            config: {
                schema: JSON.stringify(formSchema.schema),
                resources: {
                    styles: {
                        "bootstrap.min.css": theme_1.BOOTSTRAP4_CSS_URL,
                    },
                    scripts: {
                        "jquery.js": theme_1.JQUERY_URL,
                        "bootstrap.bundle.min.js": theme_1.BOOTSTRAP4_JS_URL,
                    },
                },
            },
        };
    },
};
//# sourceMappingURL=jbpmBootstrap4FormCodeGeneratorTheme.js.map