import { useCallback, useEffect, useMemo, useRef, useState } from "react";
import { dataPathToFormFieldPath } from "./uniforms/utils";
import { diff } from "deep-object-diff";
import cloneDeep from "lodash/cloneDeep";
import { FormStatus } from "./FormStatus";
import { Validator } from "./Validator";
const getObjectByPath = (obj, path) => path.split(".").reduce((acc, key) => { var _a; return (_a = acc === null || acc === void 0 ? void 0 : acc[key]) !== null && _a !== void 0 ? _a : {}; }, obj);
export function useForm({ formError, setFormError, formInputs, setFormInputs, formSchema, onSubmit, onValidate, entryPath = "definitions", propertiesEntryPath = "definitions", validator, removeRequired = false, i18n, setFormRef, }) {
    const errorBoundaryRef = useRef(null);
    const [jsonSchemaBridge, setJsonSchemaBridge] = useState();
    const [formStatus, setFormStatus] = useState(FormStatus.EMPTY);
    const formValidator = useMemo(() => (validator ? validator : new Validator(i18n)), [validator, i18n]);
    const [ref, setRef] = useState(null);
    const onFormSubmit = useCallback((formInputs) => {
        onSubmit === null || onSubmit === void 0 ? void 0 : onSubmit(formInputs);
    }, [onSubmit]);
    const onFormValidate = useCallback((formInputs, error) => {
        onValidate === null || onValidate === void 0 ? void 0 : onValidate(formInputs, error);
        setFormInputs((previousInputs) => {
            if (Object.keys(diff(formInputs, previousInputs !== null && previousInputs !== void 0 ? previousInputs : {})).length > 0) {
                return formInputs;
            }
            return previousInputs !== null && previousInputs !== void 0 ? previousInputs : {};
        });
        if (!error) {
            return;
        }
        const { details, changes, } = error.details.reduce((infos, detail) => {
            if (detail.keyword === "type") {
                const formFieldPath = dataPathToFormFieldPath(detail.instancePath);
                infos.changes = [...infos.changes, [formFieldPath, undefined]];
                return infos;
            }
            else if (detail.keyword === "enum") {
                const formFieldPath = dataPathToFormFieldPath(detail.instancePath);
                infos.changes = [...infos.changes, [formFieldPath, undefined]];
                return infos;
            }
            infos.details = [...infos.details, detail];
            return infos;
        }, { details: [], changes: [] });
        changes.forEach(([formFieldPath, fieldValue]) => {
            var _a;
            (_a = formFieldPath === null || formFieldPath === void 0 ? void 0 : formFieldPath.split(".")) === null || _a === void 0 ? void 0 : _a.reduce((deeper, field, index, array) => {
                if (index === array.length - 1) {
                    deeper[field] = fieldValue;
                }
                else {
                    return deeper[field];
                }
            }, formInputs);
        });
        return { details };
    }, [onValidate, setFormInputs]);
    useEffect(() => {
        try {
            const form = cloneDeep(formSchema !== null && formSchema !== void 0 ? formSchema : {});
            if (removeRequired) {
                const entry = getObjectByPath(form, entryPath);
                delete entry.required;
                delete form.required;
            }
            setJsonSchemaBridge(formValidator.getBridge(form));
            setFormStatus(FormStatus.WITHOUT_ERROR);
        }
        catch (err) {
            console.error(err);
            setFormStatus(FormStatus.VALIDATOR_ERROR);
        }
    }, [setFormInputs, formSchema, formValidator, entryPath, removeRequired]);
    useEffect(() => {
        var _a, _b, _c;
        if (formError) {
            setFormStatus(FormStatus.AUTO_GENERATION_ERROR);
        }
        else if (!formSchema ||
            Object.keys((_b = getObjectByPath((_a = formSchema) !== null && _a !== void 0 ? _a : {}, propertiesEntryPath)) !== null && _b !== void 0 ? _b : {}).length === 0) {
            setFormStatus(FormStatus.EMPTY);
        }
        else if (jsonSchemaBridge) {
            setFormStatus(FormStatus.WITHOUT_ERROR);
            (_c = errorBoundaryRef.current) === null || _c === void 0 ? void 0 : _c.reset();
        }
    }, [formError, formSchema, jsonSchemaBridge, propertiesEntryPath]);
    useEffect(() => {
        var _a;
        (_a = errorBoundaryRef.current) === null || _a === void 0 ? void 0 : _a.reset();
    }, [formSchema]);
    useEffect(() => {
        setFormError(false);
    }, [formInputs]);
    useEffect(() => {
        ref === null || ref === void 0 ? void 0 : ref.submit();
        setFormRef === null || setFormRef === void 0 ? void 0 : setFormRef(ref);
    }, [setFormRef, ref]);
    return {
        onSubmit: onFormSubmit,
        onValidate: onFormValidate,
        formStatus,
        jsonSchemaBridge,
        errorBoundaryRef,
        setFormRef: setRef,
    };
}
//# sourceMappingURL=FormHook.js.map