import { useEffect, useRef } from "react";
export function useEffectAfterFirstRender(effect, b) {
    const didMountRef = useRef(false);
    useEffect(() => {
        if (didMountRef.current) {
            return effect();
        }
        didMountRef.current = true;
    }, b);
}
//# sourceMappingURL=useEffectAfterFirstRender.js.map