import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { useMemo } from "react";
import { DescriptionField, ExpressionLanguageField, TypeRefField } from "../Fields";
import { useBoxedExpressionUpdater } from "./useBoxedExpressionUpdater";
import { ClipboardCopy } from "@patternfly/react-core/dist/js/components/ClipboardCopy";
import { FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { ConstraintsFromTypeConstraintAttribute } from "../../dataTypes/Constraints";
import { DmnBuiltInDataType } from "@kie-tools/boxed-expression-component/dist/api";
import { useDmnEditor } from "../../DmnEditorContext";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../../store/StoreContext";
import { useExternalModels } from "../../includedModels/DmnEditorDependenciesContext";
export function DecisionTableOutputRuleCell(props) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j;
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const selectedObjectId = useDmnEditorStore((s) => s.boxedExpressionEditor.selectedObjectId);
    const { externalModelsByNamespace } = useExternalModels();
    const { dmnEditorRootElementRef } = useDmnEditor();
    const selectedObjectInfos = useMemo(() => { var _a; return (_a = props.boxedExpressionIndex) === null || _a === void 0 ? void 0 : _a.get(selectedObjectId !== null && selectedObjectId !== void 0 ? selectedObjectId : ""); }, [props.boxedExpressionIndex, selectedObjectId]);
    const root = useMemo(() => {
        var _a, _b, _c;
        return (_a = props.boxedExpressionIndex) === null || _a === void 0 ? void 0 : _a.get((_c = (_b = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath[(selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath.length) - 1]) === null || _b === void 0 ? void 0 : _b.root) !== null && _c !== void 0 ? _c : "");
    }, [props.boxedExpressionIndex, selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath]);
    const cell = useMemo(() => selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.cell, [selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.cell]);
    const cellMustHaveSameTypeAsRoot = useMemo(() => {
        var _a, _b;
        return ((_a = root === null || root === void 0 ? void 0 : root.cell) === null || _a === void 0 ? void 0 : _a.output.length) === 1 &&
            (((_b = root === null || root === void 0 ? void 0 : root.cell) === null || _b === void 0 ? void 0 : _b["@_typeRef"]) === (cell === null || cell === void 0 ? void 0 : cell["@_typeRef"]) ||
                (cell === null || cell === void 0 ? void 0 : cell["@_typeRef"]) === undefined);
    }, [cell, root === null || root === void 0 ? void 0 : root.cell]);
    const headerType = useMemo(() => {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j;
        const cellPath = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath[(selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath.length) - 1];
        if (cellPath && cellPath.root) {
            const { allDataTypesById, allTopLevelItemDefinitionUniqueNames } = dmnEditorStoreApi
                .getState()
                .computed(dmnEditorStoreApi.getState())
                .getDataTypes(externalModelsByNamespace);
            if (((_a = root === null || root === void 0 ? void 0 : root.expressionPath[root.expressionPath.length - 1]) === null || _a === void 0 ? void 0 : _a.type) === "decisionTable" &&
                cellPath.type === "decisionTable") {
                const typeRef = (_h = allTopLevelItemDefinitionUniqueNames.get(cellMustHaveSameTypeAsRoot
                    ? (_c = (_b = root === null || root === void 0 ? void 0 : root.cell) === null || _b === void 0 ? void 0 : _b["@_typeRef"]) !== null && _c !== void 0 ? _c : ""
                    : (_g = (_e = (_d = root === null || root === void 0 ? void 0 : root.cell) === null || _d === void 0 ? void 0 : _d.output) === null || _e === void 0 ? void 0 : _e[(_f = cellPath.column) !== null && _f !== void 0 ? _f : 0]["@_typeRef"]) !== null && _g !== void 0 ? _g : "")) !== null && _h !== void 0 ? _h : DmnBuiltInDataType.Undefined;
                return { typeRef, itemDefinition: (_j = allDataTypesById.get(typeRef)) === null || _j === void 0 ? void 0 : _j.itemDefinition };
            }
        }
    }, [
        cellMustHaveSameTypeAsRoot,
        dmnEditorStoreApi,
        externalModelsByNamespace,
        root === null || root === void 0 ? void 0 : root.cell,
        root === null || root === void 0 ? void 0 : root.expressionPath,
        selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath,
    ]);
    const updater = useBoxedExpressionUpdater((_a = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _a !== void 0 ? _a : []);
    return (_jsxs(_Fragment, { children: [_jsx(FormGroup, { label: "ID", children: _jsx(ClipboardCopy, { isReadOnly: true, hoverTip: "Copy", clickTip: "Copied", children: selectedObjectId }) }), headerType && (_jsx(_Fragment, { children: _jsx(TypeRefField, { alternativeFieldName: "Output header type", isReadOnly: true, dmnEditorRootElementRef: dmnEditorRootElementRef, typeRef: cellMustHaveSameTypeAsRoot
                        ? (_b = root === null || root === void 0 ? void 0 : root.cell) === null || _b === void 0 ? void 0 : _b["@_typeRef"]
                        : (_d = (_c = headerType.itemDefinition) === null || _c === void 0 ? void 0 : _c["@_name"]) !== null && _d !== void 0 ? _d : headerType.typeRef }) })), (headerType === null || headerType === void 0 ? void 0 : headerType.itemDefinition) && (_jsx(_Fragment, { children: _jsx(FormGroup, { label: "Constraint", children: _jsx(ConstraintsFromTypeConstraintAttribute, { isReadOnly: true, itemDefinition: headerType.itemDefinition, editItemDefinition: () => { }, renderOnPropertiesPanel: true, defaultsToAllowedValues: true }) }) })), _jsx(ExpressionLanguageField, { isReadOnly: props.isReadOnly, initialValue: (_e = cell["@_expressionLanguage"]) !== null && _e !== void 0 ? _e : "", expressionPath: (_f = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _f !== void 0 ? _f : [], onChange: (newExpressionLanguage) => updater((dmnObject) => {
                    dmnObject["@_expressionLanguage"] = newExpressionLanguage;
                }) }), _jsx(DescriptionField, { isReadOnly: props.isReadOnly, initialValue: (_h = (_g = cell.description) === null || _g === void 0 ? void 0 : _g.__$$text) !== null && _h !== void 0 ? _h : "", expressionPath: (_j = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _j !== void 0 ? _j : [], onChange: (newDescription) => updater((dmnObject) => {
                    var _a;
                    (_a = dmnObject.description) !== null && _a !== void 0 ? _a : (dmnObject.description = { __$$text: "" });
                    dmnObject.description.__$$text = newDescription;
                }) })] }));
}
//# sourceMappingURL=DecisionTableOutputRuleCell.js.map