import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { useCallback, useMemo, useState } from "react";
import { ContentField, DescriptionField, ExpressionLanguageField, NameField, TypeRefField } from "../Fields";
import { FormGroup, FormSection } from "@patternfly/react-core/dist/js/components/Form";
import { buildXmlHref } from "@kie-tools/dmn-marshaller/dist/xml/xmlHrefs";
import { PropertiesPanelHeader } from "../PropertiesPanelHeader";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { useDmnEditor } from "../../DmnEditorContext";
import { useBoxedExpressionUpdater } from "./useBoxedExpressionUpdater";
import { ClipboardCopy } from "@patternfly/react-core/dist/js/components/ClipboardCopy";
import { ConstraintsFromTypeConstraintAttribute } from "../../dataTypes/Constraints";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../../store/StoreContext";
import { useExternalModels } from "../../includedModels/DmnEditorDependenciesContext";
import { useRefactor } from "../../refactor/RefactorConfirmationDialog";
export function DecisionTableOutputHeaderCell(props) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y;
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const selectedObjectId = useDmnEditorStore((s) => s.boxedExpressionEditor.selectedObjectId);
    const activeDrgElementId = useDmnEditorStore((s) => s.boxedExpressionEditor.activeDrgElementId);
    const { dmnEditorRootElementRef } = useDmnEditor();
    const { externalModelsByNamespace } = useExternalModels();
    const node = useDmnEditorStore((s) => s
        .computed(s)
        .getDiagramData(externalModelsByNamespace)
        .nodesById.get(buildXmlHref({ id: activeDrgElementId !== null && activeDrgElementId !== void 0 ? activeDrgElementId : "" })));
    const selectedObjectInfos = useMemo(() => { var _a; return (_a = props.boxedExpressionIndex) === null || _a === void 0 ? void 0 : _a.get(selectedObjectId !== null && selectedObjectId !== void 0 ? selectedObjectId : ""); }, [props.boxedExpressionIndex, selectedObjectId]);
    const updater = useBoxedExpressionUpdater((_a = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _a !== void 0 ? _a : []);
    const cell = useMemo(() => selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.cell, [selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.cell]);
    const defaultOutputEntry = useMemo(() => cell.defaultOutputEntry, [cell.defaultOutputEntry]);
    const outputValues = useMemo(() => cell.outputValues, [cell.outputValues]);
    const root = useMemo(() => {
        var _a, _b, _c, _d;
        return (_d = (_a = props.boxedExpressionIndex) === null || _a === void 0 ? void 0 : _a.get((_c = (_b = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath[(selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath.length) - 1]) === null || _b === void 0 ? void 0 : _b.root) !== null && _c !== void 0 ? _c : "")) === null || _d === void 0 ? void 0 : _d.cell;
    }, [props.boxedExpressionIndex, selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath]);
    const cellMustHaveSameTypeAsRoot = useMemo(() => (root === null || root === void 0 ? void 0 : root.output.length) === 1 && ((root === null || root === void 0 ? void 0 : root["@_typeRef"]) === (cell === null || cell === void 0 ? void 0 : cell["@_typeRef"]) || (cell === null || cell === void 0 ? void 0 : cell["@_typeRef"]) === undefined), [cell, root]);
    const itemDefinition = useMemo(() => {
        var _a, _b, _c, _d;
        const { allDataTypesById, allTopLevelItemDefinitionUniqueNames } = dmnEditorStoreApi
            .getState()
            .computed(dmnEditorStoreApi.getState())
            .getDataTypes(externalModelsByNamespace);
        return (_d = allDataTypesById.get((_c = allTopLevelItemDefinitionUniqueNames.get(cellMustHaveSameTypeAsRoot ? (_a = root === null || root === void 0 ? void 0 : root["@_typeRef"]) !== null && _a !== void 0 ? _a : "" : (_b = cell === null || cell === void 0 ? void 0 : cell["@_typeRef"]) !== null && _b !== void 0 ? _b : "")) !== null && _c !== void 0 ? _c : "")) === null || _d === void 0 ? void 0 : _d.itemDefinition;
    }, [cell, cellMustHaveSameTypeAsRoot, dmnEditorStoreApi, externalModelsByNamespace, root]);
    const [isDefaultOutputEntryExpanded, setDefaultOutputEntryExpanded] = useState(false);
    const [isOutputValuesExpanded, setOutputValuesExpanded] = useState(false);
    const getAllUniqueNames = useCallback((s) => new Map(), []);
    const alternativeFieldName = useMemo(() => {
        if ((selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath.length) === 1) {
            return "Decision";
        }
        const parentType = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath[(selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath.length) - 2].type;
        switch (parentType) {
            case "context":
                return "Entry";
            case "functionDefinition":
                return "Function";
            case "invocation":
                return "Parameter";
            case "list":
                return "Item";
            case "conditional":
            case "every":
            case "filter":
            case "for":
            case "some":
            default:
                return "Expression";
        }
    }, [selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath]);
    const identifierId = useMemo(() => { var _a; return (_a = root === null || root === void 0 ? void 0 : root["@_id"]) !== null && _a !== void 0 ? _a : ""; }, [root]);
    const oldName = useMemo(() => { var _a; return (_a = root === null || root === void 0 ? void 0 : root["@_label"]) !== null && _a !== void 0 ? _a : ""; }, [root]);
    const { setNewIdentifierNameCandidate, refactorConfirmationDialog } = useRefactor({
        index: (_b = node === null || node === void 0 ? void 0 : node.data.index) !== null && _b !== void 0 ? _b : 0,
        identifierId,
        oldName,
    });
    return (_jsxs(_Fragment, { children: [refactorConfirmationDialog, _jsx(FormGroup, { label: "ID", children: _jsx(ClipboardCopy, { isReadOnly: true, hoverTip: "Copy", clickTip: "Copied", children: selectedObjectId }) }), (root === null || root === void 0 ? void 0 : root.output.length) === 1 && (_jsxs(_Fragment, { children: [_jsx(NameField, { alternativeFieldName: `${alternativeFieldName} Name`, isReadOnly: false, id: root["@_id"], name: (_c = root === null || root === void 0 ? void 0 : root["@_label"]) !== null && _c !== void 0 ? _c : "", getAllUniqueNames: getAllUniqueNames, onChange: setNewIdentifierNameCandidate }), _jsx(TypeRefField, { alternativeFieldName: `${alternativeFieldName} Type`, isReadOnly: false, dmnEditorRootElementRef: dmnEditorRootElementRef, typeRef: root === null || root === void 0 ? void 0 : root["@_typeRef"], onChange: (newTypeRef) => {
                            dmnEditorStoreApi.setState((state) => {
                                var _a, _b, _c, _d;
                                const drgElement = state.dmn.model.definitions.drgElement[(_a = node === null || node === void 0 ? void 0 : node.data.index) !== null && _a !== void 0 ? _a : 0];
                                (_b = drgElement.variable) !== null && _b !== void 0 ? _b : (drgElement.variable = {
                                    "@_id": generateUuid(),
                                    "@_name": (_d = (_c = node === null || node === void 0 ? void 0 : node.data.dmnObject) === null || _c === void 0 ? void 0 : _c["@_name"]) !== null && _d !== void 0 ? _d : "",
                                });
                                drgElement.variable["@_typeRef"] = newTypeRef;
                            });
                        } })] })), (root === null || root === void 0 ? void 0 : root.output) && root.output.length > 1 ? (_jsx(NameField, { isReadOnly: props.isReadOnly, id: cell["@_id"], name: (_d = cell === null || cell === void 0 ? void 0 : cell["@_name"]) !== null && _d !== void 0 ? _d : "", getAllUniqueNames: getAllUniqueNames, onChange: (newName) => updater((dmnObject) => {
                    dmnObject["@_name"] = newName;
                }) })) : (""), (root === null || root === void 0 ? void 0 : root.output) && root.output.length > 1 ? (_jsx(TypeRefField, { isReadOnly: cellMustHaveSameTypeAsRoot ? true : props.isReadOnly, dmnEditorRootElementRef: dmnEditorRootElementRef, typeRef: cellMustHaveSameTypeAsRoot ? root === null || root === void 0 ? void 0 : root["@_typeRef"] : cell === null || cell === void 0 ? void 0 : cell["@_typeRef"], onChange: (newTypeRef) => updater((dmnObject) => {
                    dmnObject["@_typeRef"] = newTypeRef;
                }) })) : (""), itemDefinition && (_jsx(FormGroup, { label: "Constraint", children: _jsx(ConstraintsFromTypeConstraintAttribute, { isReadOnly: true, itemDefinition: itemDefinition, editItemDefinition: () => { }, renderOnPropertiesPanel: true, defaultsToAllowedValues: true }) })), _jsx(DescriptionField, { isReadOnly: props.isReadOnly, expressionPath: (_e = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _e !== void 0 ? _e : [], initialValue: (_g = (_f = cell === null || cell === void 0 ? void 0 : cell.description) === null || _f === void 0 ? void 0 : _f.__$$text) !== null && _g !== void 0 ? _g : "", onChange: (newDescription) => updater((dmnObject) => {
                    var _a;
                    (_a = dmnObject.description) !== null && _a !== void 0 ? _a : (dmnObject.description = { __$$text: "" });
                    dmnObject.description.__$$text = newDescription;
                }) }), _jsxs(FormSection, { children: [_jsx(PropertiesPanelHeader, { expands: true, fixed: false, isSectionExpanded: isDefaultOutputEntryExpanded, toogleSectionExpanded: () => setDefaultOutputEntryExpanded((prev) => !prev), title: "Default Output Entry" }), isDefaultOutputEntryExpanded && (_jsxs(_Fragment, { children: [_jsx(ExpressionLanguageField, { isReadOnly: props.isReadOnly, initialValue: (_h = defaultOutputEntry === null || defaultOutputEntry === void 0 ? void 0 : defaultOutputEntry["@_expressionLanguage"]) !== null && _h !== void 0 ? _h : "", expressionPath: (_j = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _j !== void 0 ? _j : [], onChange: (newExpressionLanguage) => updater((dmnObject) => {
                                    var _a;
                                    (_a = dmnObject.defaultOutputEntry) !== null && _a !== void 0 ? _a : (dmnObject.defaultOutputEntry = { "@_id": generateUuid() });
                                    dmnObject.defaultOutputEntry["@_expressionLanguage"] = newExpressionLanguage;
                                }) }), _jsx(ContentField, { isReadOnly: props.isReadOnly, initialValue: (_l = (_k = defaultOutputEntry === null || defaultOutputEntry === void 0 ? void 0 : defaultOutputEntry.text) === null || _k === void 0 ? void 0 : _k.__$$text) !== null && _l !== void 0 ? _l : "", expressionPath: (_m = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _m !== void 0 ? _m : [], onChange: (newText) => updater((dmnObject) => {
                                    var _a, _b;
                                    var _c;
                                    (_a = dmnObject.defaultOutputEntry) !== null && _a !== void 0 ? _a : (dmnObject.defaultOutputEntry = { "@_id": generateUuid(), text: { __$$text: "" } });
                                    (_b = (_c = dmnObject.defaultOutputEntry).text) !== null && _b !== void 0 ? _b : (_c.text = { __$$text: "" });
                                    dmnObject.defaultOutputEntry.text.__$$text = newText;
                                }) }), _jsx(DescriptionField, { isReadOnly: props.isReadOnly, initialValue: (_p = (_o = defaultOutputEntry === null || defaultOutputEntry === void 0 ? void 0 : defaultOutputEntry.description) === null || _o === void 0 ? void 0 : _o.__$$text) !== null && _p !== void 0 ? _p : "", expressionPath: (_q = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _q !== void 0 ? _q : [], onChange: (newDescription) => updater((dmnObject) => {
                                    var _a, _b;
                                    var _c;
                                    (_a = dmnObject.defaultOutputEntry) !== null && _a !== void 0 ? _a : (dmnObject.defaultOutputEntry = { "@_id": generateUuid(), description: { __$$text: "" } });
                                    (_b = (_c = dmnObject.defaultOutputEntry).description) !== null && _b !== void 0 ? _b : (_c.description = { __$$text: "" });
                                    dmnObject.defaultOutputEntry.description.__$$text = newDescription;
                                }) })] }))] }), _jsxs(FormSection, { children: [_jsx(PropertiesPanelHeader, { expands: true, fixed: false, isSectionExpanded: isOutputValuesExpanded, toogleSectionExpanded: () => setOutputValuesExpanded((prev) => !prev), title: "Output Values" }), isOutputValuesExpanded && (_jsxs(_Fragment, { children: [_jsx(ExpressionLanguageField, { isReadOnly: props.isReadOnly, initialValue: (_r = outputValues === null || outputValues === void 0 ? void 0 : outputValues["@_expressionLanguage"]) !== null && _r !== void 0 ? _r : "", expressionPath: (_s = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _s !== void 0 ? _s : [], onChange: (newExpressionLanguage) => updater((dmnObject) => {
                                    var _a;
                                    (_a = dmnObject.outputValues) !== null && _a !== void 0 ? _a : (dmnObject.outputValues = { "@_id": generateUuid(), text: { __$$text: "" } });
                                    dmnObject.outputValues["@_expressionLanguage"] = newExpressionLanguage;
                                }) }), _jsx(ContentField, { isReadOnly: props.isReadOnly, initialValue: (_u = (_t = outputValues === null || outputValues === void 0 ? void 0 : outputValues.text) === null || _t === void 0 ? void 0 : _t.__$$text) !== null && _u !== void 0 ? _u : "", expressionPath: (_v = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _v !== void 0 ? _v : [], onChange: (newText) => updater((dmnObject) => {
                                    var _a;
                                    (_a = dmnObject.outputValues) !== null && _a !== void 0 ? _a : (dmnObject.outputValues = { "@_id": generateUuid(), text: { __$$text: "" } });
                                    dmnObject.outputValues.text.__$$text = newText;
                                }) }), _jsx(DescriptionField, { isReadOnly: props.isReadOnly, initialValue: (_x = (_w = outputValues === null || outputValues === void 0 ? void 0 : outputValues.description) === null || _w === void 0 ? void 0 : _w.__$$text) !== null && _x !== void 0 ? _x : "", expressionPath: (_y = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _y !== void 0 ? _y : [], onChange: (newDescription) => updater((dmnObject) => {
                                    var _a, _b;
                                    var _c;
                                    (_a = dmnObject.outputValues) !== null && _a !== void 0 ? _a : (dmnObject.outputValues = { "@_id": generateUuid(), text: { __$$text: "" } });
                                    (_b = (_c = dmnObject.outputValues).description) !== null && _b !== void 0 ? _b : (_c.description = { __$$text: "" });
                                    dmnObject.outputValues.description.__$$text = newDescription;
                                }) })] }))] })] }));
}
//# sourceMappingURL=DecisionTableOutputHeaderCell.js.map