import { getNewDmnIdRandomizer } from "@kie-tools/dmn-marshaller/dist/idRandomizer/dmnIdRandomizer";
import { buildXmlHref, xmlHrefToQName } from "@kie-tools/dmn-marshaller/dist/xml";
import { NodeNature } from "./NodeNature";
import { addOrGetDrd } from "./addOrGetDrd";
import { repopulateInputDataAndDecisionsOnAllDecisionServices } from "./repopulateInputDataAndDecisionsOnDecisionService";
import { buildXmlQName } from "@kie-tools/xml-parser-ts/dist/qNames";
import { EdgeDeletionMode, deleteEdge } from "./deleteEdge";
import { computeContainingDecisionServiceHrefsByDecisionHrefs } from "../store/computed/computeContainingDecisionServiceHrefsByDecisionHrefs.ts";
export var NodeDeletionMode;
(function (NodeDeletionMode) {
    NodeDeletionMode[NodeDeletionMode["FROM_DRG_AND_ALL_DRDS"] = 0] = "FROM_DRG_AND_ALL_DRDS";
    NodeDeletionMode[NodeDeletionMode["FROM_CURRENT_DRD_ONLY"] = 1] = "FROM_CURRENT_DRD_ONLY";
})(NodeDeletionMode || (NodeDeletionMode = {}));
export function deleteNode({ definitions, __readonly_drgEdges, __readonly_drdIndex, __readonly_nodeNature, __readonly_dmnObjectId, __readonly_dmnObjectNamespace, __readonly_dmnObjectQName, __readonly_externalDmnsIndex, __readonly_mode, __readonly_externalModelsByNamespace, }) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o;
    if (__readonly_mode === NodeDeletionMode.FROM_CURRENT_DRD_ONLY &&
        !canRemoveNodeFromDrdOnly({
            definitions,
            __readonly_drdIndex,
            __readonly_dmnObjectNamespace,
            __readonly_dmnObjectId,
            __readonly_externalDmnsIndex,
        })) {
        console.warn("DMN MUTATION: Cannot hide a Decision that's contained by a Decision Service from a DRD.");
        return { deletedDmnObject: undefined, deletedDmnShapeOnCurrentDrd: undefined };
    }
    if (!isContainedInAnExternalExpandedDecisionService({
        definitions,
        __readonly_drdIndex,
        __readonly_dmnObjectNamespace,
        __readonly_dmnObjectId,
        __readonly_externalDmnsIndex,
    })) {
        console.warn("DMN MUTATION: Cannot delete a Decision that's contained by a expanded external Decision Service.");
        return { deletedDmnObject: undefined, deletedDmnShapeOnCurrentDrd: undefined };
    }
    if (__readonly_mode === NodeDeletionMode.FROM_DRG_AND_ALL_DRDS) {
        const nodeId = buildXmlHref({
            namespace: __readonly_dmnObjectNamespace === definitions["@_namespace"] ? undefined : __readonly_dmnObjectNamespace,
            id: __readonly_dmnObjectId,
        });
        for (let i = 0; i < __readonly_drgEdges.length; i++) {
            const drgEdge = __readonly_drgEdges[i];
            if (drgEdge.sourceId === nodeId || drgEdge.targetId === nodeId) {
                deleteEdge({
                    definitions,
                    drdIndex: __readonly_drdIndex,
                    mode: EdgeDeletionMode.FROM_DRG_AND_ALL_DRDS,
                    edge: {
                        id: drgEdge.id,
                        dmnObject: drgEdge.dmnObject,
                    },
                    externalModelsByNamespace: __readonly_externalModelsByNamespace,
                });
            }
        }
        const drgElements = (_a = definitions.drgElement) !== null && _a !== void 0 ? _a : [];
        for (let i = 0; i < drgElements.length; i++) {
            const drgElement = drgElements[i];
            if (drgElement.__$$element !== "decisionService") {
                continue;
            }
            drgElement.outputDecision = (_b = drgElement.outputDecision) === null || _b === void 0 ? void 0 : _b.filter((od) => od["@_href"] !== nodeId);
            drgElement.encapsulatedDecision = (_c = drgElement.encapsulatedDecision) === null || _c === void 0 ? void 0 : _c.filter((ed) => ed["@_href"] !== nodeId);
        }
    }
    let deletedDmnObject;
    if (!__readonly_dmnObjectQName.prefix) {
        if (__readonly_nodeNature === NodeNature.ARTIFACT) {
            if (__readonly_mode === NodeDeletionMode.FROM_DRG_AND_ALL_DRDS) {
                const nodeIndex = ((_d = definitions.artifact) !== null && _d !== void 0 ? _d : []).findIndex((a) => a["@_id"] === __readonly_dmnObjectId);
                deletedDmnObject = (_f = (_e = definitions.artifact) === null || _e === void 0 ? void 0 : _e.splice(nodeIndex, 1)) === null || _f === void 0 ? void 0 : _f[0];
            }
            else {
                throw new Error(`DMN MUTATION: Can't hide an artifact node.`);
            }
        }
        else if (__readonly_nodeNature === NodeNature.DRG_ELEMENT) {
            const nodeIndex = ((_g = definitions.drgElement) !== null && _g !== void 0 ? _g : []).findIndex((d) => d["@_id"] === __readonly_dmnObjectId);
            deletedDmnObject =
                __readonly_mode === NodeDeletionMode.FROM_DRG_AND_ALL_DRDS
                    ? (_j = (_h = definitions.drgElement) === null || _h === void 0 ? void 0 : _h.splice(nodeIndex, 1)) === null || _j === void 0 ? void 0 : _j[0]
                    : (_k = definitions.drgElement) === null || _k === void 0 ? void 0 : _k[nodeIndex];
        }
        else if (__readonly_nodeNature === NodeNature.UNKNOWN) {
        }
        else {
            throw new Error(`DMN MUTATION: Unknown node nature '${__readonly_nodeNature}'.`);
        }
        if (!deletedDmnObject && __readonly_nodeNature !== NodeNature.UNKNOWN) {
            throw new Error(`DMN MUTATION: Can't delete DMN object that doesn't exist: ID=${__readonly_dmnObjectId}`);
        }
    }
    const shapeDmnElementRef = buildXmlQName(__readonly_dmnObjectQName);
    let deletedDmnShapeOnCurrentDrd;
    const deletedIdsOnDmnObjectTree = deletedDmnObject
        ? getNewDmnIdRandomizer()
            .ack({ json: [deletedDmnObject], type: "DMN15__tDefinitions", attr: "drgElement" })
            .getOriginalIds()
        : new Set();
    const drdCount = ((_m = (_l = definitions["dmndi:DMNDI"]) === null || _l === void 0 ? void 0 : _l["dmndi:DMNDiagram"]) !== null && _m !== void 0 ? _m : []).length;
    for (let i = 0; i < drdCount; i++) {
        if (__readonly_mode === NodeDeletionMode.FROM_CURRENT_DRD_ONLY && i !== __readonly_drdIndex) {
            continue;
        }
        const { diagramElements, widthsExtension } = addOrGetDrd({ definitions, drdIndex: i });
        const dmnShapeIndex = (diagramElements !== null && diagramElements !== void 0 ? diagramElements : []).findIndex((d) => d["@_dmnElementRef"] === shapeDmnElementRef);
        if (dmnShapeIndex >= 0) {
            if (i === __readonly_drdIndex) {
                deletedDmnShapeOnCurrentDrd = diagramElements[dmnShapeIndex];
            }
            diagramElements === null || diagramElements === void 0 ? void 0 : diagramElements.splice(dmnShapeIndex, 1);
        }
        widthsExtension["kie:ComponentWidths"] = (_o = widthsExtension["kie:ComponentWidths"]) === null || _o === void 0 ? void 0 : _o.filter((w) => !deletedIdsOnDmnObjectTree.has(w["@_dmnElementRef"]));
    }
    repopulateInputDataAndDecisionsOnAllDecisionServices({
        definitions,
        externalModelsByNamespace: __readonly_externalModelsByNamespace,
    });
    return {
        deletedDmnObject: __readonly_mode === NodeDeletionMode.FROM_DRG_AND_ALL_DRDS ? deletedDmnObject : undefined,
        deletedDmnShapeOnCurrentDrd,
    };
}
export function isContainedInAnExternalExpandedDecisionService({ definitions, __readonly_drdIndex, __readonly_dmnObjectNamespace, __readonly_dmnObjectId, __readonly_externalDmnsIndex, }) {
    var _a;
    const { diagramElements } = addOrGetDrd({ definitions, drdIndex: __readonly_drdIndex });
    const dmnObjectHref = buildXmlHref({
        namespace: __readonly_dmnObjectNamespace === definitions["@_namespace"] ? undefined : __readonly_dmnObjectNamespace,
        id: __readonly_dmnObjectId,
    });
    const drgElementsByNamespace = new Map();
    __readonly_externalDmnsIndex.forEach((value, key) => {
        drgElementsByNamespace.set(key, value.model.definitions.drgElement);
    });
    const containingDecisionServiceHrefsByDecisionHrefsRelativeToThisDmn = computeContainingDecisionServiceHrefsByDecisionHrefs({
        thisDmnsNamespace: definitions["@_namespace"],
        drgElementsByNamespace,
    });
    const isContainingDecisionServiceInExpandedFormPresentInTheDrd = ((_a = containingDecisionServiceHrefsByDecisionHrefsRelativeToThisDmn.get(dmnObjectHref)) !== null && _a !== void 0 ? _a : []).some((dsHref) => diagramElements.some((e) => {
        var _a;
        return e.__$$element === "dmndi:DMNShape" &&
            e["@_dmnElementRef"] === xmlHrefToQName(dsHref, definitions) &&
            !((_a = e["@_isCollapsed"]) !== null && _a !== void 0 ? _a : false);
    }));
    return !isContainingDecisionServiceInExpandedFormPresentInTheDrd;
}
export function canRemoveNodeFromDrdOnly({ definitions, __readonly_drdIndex, __readonly_dmnObjectNamespace, __readonly_dmnObjectId, __readonly_externalDmnsIndex, }) {
    var _a;
    const { diagramElements } = addOrGetDrd({ definitions, drdIndex: __readonly_drdIndex });
    const dmnObjectHref = buildXmlHref({
        namespace: __readonly_dmnObjectNamespace === definitions["@_namespace"] ? undefined : __readonly_dmnObjectNamespace,
        id: __readonly_dmnObjectId,
    });
    const drgElementsByNamespace = new Map([[definitions["@_namespace"], definitions.drgElement]]);
    __readonly_externalDmnsIndex.forEach((value, key) => {
        drgElementsByNamespace.set(key, value.model.definitions.drgElement);
    });
    const containingDecisionServiceHrefsByDecisionHrefsRelativeToThisDmn = computeContainingDecisionServiceHrefsByDecisionHrefs({
        thisDmnsNamespace: definitions["@_namespace"],
        drgElementsByNamespace,
    });
    const containingDecisionServiceHrefs = (_a = containingDecisionServiceHrefsByDecisionHrefsRelativeToThisDmn.get(dmnObjectHref)) !== null && _a !== void 0 ? _a : [];
    const isContainedByDecisionService = containingDecisionServiceHrefs.length > 0;
    const isContainingDecisionServiceInExpandedFormPresentInTheDrd = containingDecisionServiceHrefs.some((dsHref) => diagramElements.some((e) => {
        var _a;
        return e.__$$element === "dmndi:DMNShape" &&
            e["@_dmnElementRef"] === xmlHrefToQName(dsHref, definitions) &&
            !((_a = e["@_isCollapsed"]) !== null && _a !== void 0 ? _a : false);
    }));
    return !isContainedByDecisionService || !isContainingDecisionServiceInExpandedFormPresentInTheDrd;
}
//# sourceMappingURL=deleteNode.js.map