import { PositionalNodeHandleId } from "../diagram/connections/PositionalNodeHandles";
import { NODE_TYPES } from "../diagram/nodes/NodeTypes";
import { addEdge } from "../mutations/addEdge";
import { repositionNode } from "../mutations/repositionNode";
import { resizeNode } from "../mutations/resizeNode";
import { updateDecisionServiceDividerLine } from "../mutations/updateDecisionServiceDividerLine";
import { FAKE_MARKER, visitNodeAndNested } from "../autolayout/autoLayoutInfo";
export function applyAutoLayoutToDrd({ state, __readonly_autoLayoutedInfo, __readonly_parentNodesById, __readonly_nodesById, __readonly_edgesById, __readonly_edges, __readonly_dmnShapesByHref, __readonly_drdIndex, __readonly_dmnObjectNamespace, __readonly_externalDmnsIndex, __readonly_externalModelsByNamespace, }) {
    var _a, _b, _c, _d, _e;
    const autolayoutedElkNodesById = new Map();
    for (const topLevelElkNode of (_a = __readonly_autoLayoutedInfo.nodes) !== null && _a !== void 0 ? _a : []) {
        visitNodeAndNested(topLevelElkNode, { x: 100, y: 100 }, (elkNode, positionOffset) => {
            var _a;
            if (elkNode.id.includes(FAKE_MARKER)) {
                return;
            }
            autolayoutedElkNodesById.set(elkNode.id, elkNode);
            const nodeId = elkNode.id;
            const node = __readonly_nodesById.get(nodeId);
            repositionNode({
                definitions: state.dmn.model.definitions,
                drdIndex: __readonly_drdIndex,
                controlWaypointsByEdge: new Map(),
                change: {
                    nodeType: node.type,
                    type: "absolute",
                    position: {
                        x: elkNode.x + positionOffset.x,
                        y: elkNode.y + positionOffset.y,
                    },
                    selectedEdges: [...__readonly_edgesById.keys()],
                    shapeIndex: (_a = node.data) === null || _a === void 0 ? void 0 : _a.shape.index,
                    sourceEdgeIndexes: __readonly_edges.flatMap((e) => { var _a; return e.source === nodeId && ((_a = e.data) === null || _a === void 0 ? void 0 : _a.dmnEdge) ? [e.data.dmnEdge.index] : []; }),
                    targetEdgeIndexes: __readonly_edges.flatMap((e) => { var _a; return e.target === nodeId && ((_a = e.data) === null || _a === void 0 ? void 0 : _a.dmnEdge) ? [e.data.dmnEdge.index] : []; }),
                },
            });
        });
    }
    for (const topLevelElkNode of (_b = __readonly_autoLayoutedInfo.nodes) !== null && _b !== void 0 ? _b : []) {
        visitNodeAndNested(topLevelElkNode, { x: 0, y: 0 }, (elkNode) => {
            var _a;
            if (elkNode.id.includes(FAKE_MARKER)) {
                return;
            }
            const nodeId = elkNode.id;
            const node = __readonly_nodesById.get(nodeId);
            resizeNode({
                definitions: state.dmn.model.definitions,
                drdIndex: __readonly_drdIndex,
                __readonly_dmnShapesByHref: __readonly_dmnShapesByHref,
                snapGrid: state.diagram.snapGrid,
                __readonly_dmnObjectNamespace,
                __readonly_externalDmnsIndex,
                change: {
                    index: node.data.index,
                    isExternal: !!node.data.dmnObjectQName.prefix,
                    nodeType: node.type,
                    dimension: {
                        "@_width": elkNode.width,
                        "@_height": elkNode.height,
                    },
                    shapeIndex: (_a = node.data) === null || _a === void 0 ? void 0 : _a.shape.index,
                    sourceEdgeIndexes: __readonly_edges.flatMap((e) => { var _a; return e.source === nodeId && ((_a = e.data) === null || _a === void 0 ? void 0 : _a.dmnEdge) ? [e.data.dmnEdge.index] : []; }),
                    targetEdgeIndexes: __readonly_edges.flatMap((e) => { var _a; return e.target === nodeId && ((_a = e.data) === null || _a === void 0 ? void 0 : _a.dmnEdge) ? [e.data.dmnEdge.index] : []; }),
                },
            });
        });
    }
    for (const [parentNodeId] of __readonly_parentNodesById) {
        const parentNode = __readonly_nodesById.get(parentNodeId);
        if ((parentNode === null || parentNode === void 0 ? void 0 : parentNode.type) !== NODE_TYPES.decisionService) {
            continue;
        }
        const elkNode = autolayoutedElkNodesById.get(parentNodeId);
        if (!elkNode) {
            throw new Error(`Couldn't find Decision Service with id ${parentNode.id} at the autolayouted nodes map`);
        }
        const dividerLinerLocalYPosition = (_d = (_c = elkNode.children) === null || _c === void 0 ? void 0 : _c[1]) === null || _d === void 0 ? void 0 : _d.y;
        if (!dividerLinerLocalYPosition) {
            throw new Error(`Couldn't find second child (which represents the Encapuslated Decision section) of Decision Service with id ${parentNode.id} at the autolayouted nodes map`);
        }
        updateDecisionServiceDividerLine({
            definitions: state.dmn.model.definitions,
            drdIndex: __readonly_drdIndex,
            __readonly_dmnShapesByHref,
            __readonly_dmnObjectNamespace,
            __readonly_externalDmnsIndex,
            drgElementIndex: parentNode.data.index,
            shapeIndex: parentNode.data.shape.index,
            snapGrid: state.diagram.snapGrid,
            localYPosition: dividerLinerLocalYPosition,
        });
    }
    for (const elkEdge of (_e = __readonly_autoLayoutedInfo.edges) !== null && _e !== void 0 ? _e : []) {
        if (elkEdge.id.includes(FAKE_MARKER)) {
            continue;
        }
        const edge = __readonly_edgesById.get(elkEdge.id);
        const sourceNode = __readonly_nodesById.get(elkEdge.sources[0]);
        const targetNode = __readonly_nodesById.get(elkEdge.targets[0]);
        if (targetNode.data.dmnObjectQName.prefix) {
            continue;
        }
        addEdge({
            definitions: state.dmn.model.definitions,
            drdIndex: __readonly_drdIndex,
            edge: {
                autoPositionedEdgeMarker: undefined,
                type: edge.type,
                targetHandle: PositionalNodeHandleId.Bottom,
                sourceHandle: PositionalNodeHandleId.Top,
            },
            sourceNode: {
                type: sourceNode.type,
                href: sourceNode.id,
                data: sourceNode.data,
                bounds: sourceNode.data.shape["dc:Bounds"],
                shapeId: sourceNode.data.shape["@_id"],
            },
            targetNode: {
                type: targetNode.type,
                href: targetNode.id,
                data: targetNode.data,
                bounds: targetNode.data.shape["dc:Bounds"],
                index: targetNode.data.index,
                shapeId: targetNode.data.shape["@_id"],
            },
            keepWaypoints: false,
            externalModelsByNamespace: __readonly_externalModelsByNamespace,
        });
    }
}
//# sourceMappingURL=applyAutoLayoutToDrd.js.map