import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { ns as dmn12ns } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_2/ts-gen/meta";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { Card, CardActions, CardBody, CardHeader, CardTitle } from "@patternfly/react-core/dist/js/components/Card";
import { Divider } from "@patternfly/react-core/dist/js/components/Divider";
import { EmptyState, EmptyStateBody, EmptyStateIcon } from "@patternfly/react-core/dist/js/components/EmptyState";
import { Form, FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { Modal, ModalVariant } from "@patternfly/react-core/dist/js/components/Modal";
import { PageSection } from "@patternfly/react-core/dist/js/components/Page";
import { Select, SelectGroup, SelectOption, SelectVariant } from "@patternfly/react-core/dist/js/components/Select";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Flex } from "@patternfly/react-core/dist/js/layouts/Flex";
import { Gallery } from "@patternfly/react-core/dist/js/layouts/Gallery";
import { CubesIcon } from "@patternfly/react-icons/dist/js/icons/cubes-icon";
import { basename, dirname, extname } from "path";
import { useCallback, useMemo, useRef, useState } from "react";
import { useDmnEditor } from "../DmnEditorContext";
import { DMN15_SPEC } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/Dmn15Spec";
import { InlineFeelNameInput } from "../feel/InlineFeelNameInput";
import { addImport } from "../mutations/addImport";
import { deleteImport } from "../mutations/deleteImport";
import { renameImport } from "../mutations/renameImport";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { KIE_UNKNOWN_NAMESPACE } from "../kie/kie";
import { ExternalModelLabel } from "./ExternalModelLabel";
import { useExternalModels } from "./DmnEditorDependenciesContext";
import { allPmmlImportNamespaces, getPmmlNamespace } from "../pmml/pmml";
import { allDmnImportNamespaces } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/Dmn15Spec";
import { getNamespaceOfDmnImport } from "./importNamespaces";
import { Alert, AlertVariant } from "@patternfly/react-core/dist/js/components/Alert/Alert";
import { KebabToggle } from "@patternfly/react-core/dist/js/components/Dropdown";
import { TrashIcon } from "@patternfly/react-icons/dist/js/icons/trash-icon";
import { useInViewSelect } from "../responsiveness/useInViewSelect";
import { useCancelableEffect } from "@kie-tools-core/react-hooks/dist/useCancelableEffect";
import "./IncludedModels.css";
import { Popover, PopoverPosition } from "@patternfly/react-core/dist/js/components/Popover";
import { AlertActionCloseButton, AlertActionLink } from "@patternfly/react-core/dist/js/components/Alert";
import { useSettings } from "../settings/DmnEditorSettingsContext";
export const EMPTY_IMPORT_NAME_NAMESPACE_IDENTIFIER = "<Default>";
const namespaceForNewImportsByFileExtension = {
    ".dmn": dmn12ns.get(""),
    ".pmml": "https://www.dmg.org/PMML-4_4",
};
export function IncludedModels() {
    var _a, _b, _c, _d;
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const thisDmnsImports = useDmnEditorStore((s) => { var _a; return (_a = s.dmn.model.definitions.import) !== null && _a !== void 0 ? _a : []; });
    const settings = useSettings();
    const { externalContextDescription, externalContextName, dmnEditorRootElementRef, onRequestToResolvePath } = useDmnEditor();
    const importsByNamespace = useDmnEditorStore((s) => s.computed(s).importsByNamespace());
    const { externalModelsByNamespace, onRequestExternalModelsAvailableToInclude, onRequestExternalModelByPath } = useExternalModels();
    const [isModalOpen, setModalOpen] = useState(false);
    const [isModelSelectOpen, setModelSelectOpen] = useState(false);
    const [selectedPathRelativeToThisDmn, setSelectedPathRelativeToThisDmn] = useState(undefined);
    const [importName, setImportName] = useState("");
    const [selectedModel, setSelectedModel] = useState(undefined);
    const [selectedModelError, setSelectedModelError] = useState(undefined);
    useCancelableEffect(useCallback(({ canceled }) => {
        if (!selectedPathRelativeToThisDmn) {
            return;
        }
        if (onRequestExternalModelByPath === undefined) {
            return;
        }
        onRequestExternalModelByPath(selectedPathRelativeToThisDmn)
            .then((externalModel) => {
            if (canceled.get()) {
                return;
            }
            if (!externalModel) {
                return;
            }
            setSelectedModelError(undefined);
            setSelectedModel(externalModel);
        })
            .catch((err) => {
            setSelectedModelError(`An error occurred when parsing the selected model '${selectedPathRelativeToThisDmn}'. Please double-check it is a non-empty valid model.`);
            console.error(err);
            return;
        });
    }, [onRequestExternalModelByPath, selectedPathRelativeToThisDmn]));
    const openModal = useCallback(() => {
        setModalOpen(true);
    }, []);
    const cancel = useCallback(() => {
        setModalOpen(false);
        setModelSelectOpen(false);
        setSelectedPathRelativeToThisDmn(undefined);
        setImportName("");
        setSelectedModelError(undefined);
    }, []);
    const add = useCallback(() => {
        const s = dmnEditorStoreApi.getState();
        if (!selectedPathRelativeToThisDmn ||
            !selectedModel ||
            !DMN15_SPEC.IMPORT.name.isValid(generateUuid(), importName, s.computed(s).getAllFeelVariableUniqueNames())) {
            return;
        }
        const xmlns = namespaceForNewImportsByFileExtension[extname(selectedPathRelativeToThisDmn)];
        if (!xmlns) {
            throw new Error(`Can't import model with an unsupported file extension: '${selectedPathRelativeToThisDmn}'.`);
        }
        const namespace = selectedModel.type === "dmn"
            ? selectedModel.model.definitions["@_namespace"]
            : selectedModel.type === "pmml"
                ? getPmmlNamespace({
                    normalizedPosixPathRelativeToTheOpenFile: selectedModel.normalizedPosixPathRelativeToTheOpenFile,
                })
                : KIE_UNKNOWN_NAMESPACE;
        setModalOpen(false);
        dmnEditorStoreApi.setState((state) => {
            addImport({
                definitions: state.dmn.model.definitions,
                includedModel: {
                    xmlns,
                    namespace,
                    name: importName,
                    normalizedPathRelativeToThisDmn: selectedModel.normalizedPosixPathRelativeToTheOpenFile,
                },
            });
        });
        setTimeout(() => {
            setSelectedModelError(undefined);
            setSelectedModel(undefined);
        }, 5000);
        cancel();
    }, [dmnEditorStoreApi, selectedPathRelativeToThisDmn, selectedModel, importName, cancel]);
    const [modelPathRelativeToThisDmn, setModelPathsRelativeToThisDmn] = useState(undefined);
    useCancelableEffect(useCallback(({ canceled }) => {
        onRequestExternalModelsAvailableToInclude === null || onRequestExternalModelsAvailableToInclude === void 0 ? void 0 : onRequestExternalModelsAvailableToInclude().then((paths) => {
            if (canceled.get()) {
                return;
            }
            setModelPathsRelativeToThisDmn(paths);
        }).catch((err) => {
            console.error(err);
            return;
        });
    }, [onRequestExternalModelsAvailableToInclude]));
    const externalModelsByPathsRelativeToThisDmn = useMemo(() => Object.entries(externalModelsByNamespace !== null && externalModelsByNamespace !== void 0 ? externalModelsByNamespace : {}).reduce((acc, [namespace, externalModel]) => {
        if (!externalModel) {
            console.warn(`DMN EDITOR: Could not find model with namespace '${namespace}'. Ignoring.`);
            return acc;
        }
        else {
            return acc.set(externalModel.normalizedPosixPathRelativeToTheOpenFile, externalModel);
        }
    }, new Map()), [externalModelsByNamespace]);
    const modelPathsRelativeToThisDmnNotYetIncluded = useMemo(() => modelPathRelativeToThisDmn &&
        modelPathRelativeToThisDmn.filter((path) => {
            const externalModel = externalModelsByPathsRelativeToThisDmn.get(path);
            return (!externalModel ||
                (externalModel.type === "dmn" && !importsByNamespace.get(externalModel.model.definitions["@_namespace"])) ||
                (externalModel.type === "pmml" &&
                    !importsByNamespace.get(getPmmlNamespace({
                        normalizedPosixPathRelativeToTheOpenFile: externalModel.normalizedPosixPathRelativeToTheOpenFile,
                    }))));
        }), [externalModelsByPathsRelativeToThisDmn, importsByNamespace, modelPathRelativeToThisDmn]);
    const pmmlPathsNotYetIncluded = useMemo(() => modelPathsRelativeToThisDmnNotYetIncluded === null || modelPathsRelativeToThisDmnNotYetIncluded === void 0 ? void 0 : modelPathsRelativeToThisDmnNotYetIncluded.filter((s) => s.endsWith(".pmml")), [modelPathsRelativeToThisDmnNotYetIncluded]);
    const dmnPathsNotYetIncluded = useMemo(() => modelPathsRelativeToThisDmnNotYetIncluded === null || modelPathsRelativeToThisDmnNotYetIncluded === void 0 ? void 0 : modelPathsRelativeToThisDmnNotYetIncluded.filter((s) => s.endsWith(".dmn")), [modelPathsRelativeToThisDmnNotYetIncluded]);
    const selectToggleRef = useRef(null);
    const inViewSelect = useInViewSelect(dmnEditorRootElementRef, selectToggleRef);
    const getAllUniqueNames = useCallback((s) => s.computed(s).getAllFeelVariableUniqueNames(), []);
    return (_jsxs(_Fragment, { children: [_jsx(Modal, { "data-testid": "kie-tools--dmn-editor--included-models-modal", isOpen: isModalOpen, onClose: () => cancel(), title: "Include model", variant: ModalVariant.large, actions: ((_a = modelPathsRelativeToThisDmnNotYetIncluded === null || modelPathsRelativeToThisDmnNotYetIncluded === void 0 ? void 0 : modelPathsRelativeToThisDmnNotYetIncluded.length) !== null && _a !== void 0 ? _a : 0) > 0 && selectedModelError === undefined
                    ? [
                        _jsx(Button, { variant: "primary", onClick: add, children: "Include model" }, "confirm"),
                        _jsx(Button, { variant: "link", onClick: cancel, children: "Cancel" }, "cancel"),
                    ]
                    : [
                        _jsx(Button, { variant: "link", onClick: cancel, style: { paddingLeft: 0 }, children: "Cancel" }, "cancel"),
                    ], children: (modelPathsRelativeToThisDmnNotYetIncluded && (_jsx(_Fragment, { children: (modelPathsRelativeToThisDmnNotYetIncluded.length > 0 && (_jsxs(_Fragment, { children: [_jsx("br", {}), externalContextDescription, _jsx("br", {}), _jsx("br", {}), _jsxs(Form, { children: [_jsx(FormGroup, { label: "Model", isRequired: true, children: _jsxs(Select, { toggleRef: selectToggleRef, maxHeight: inViewSelect.maxHeight, direction: inViewSelect.direction, menuAppendTo: document.body, variant: SelectVariant.typeahead, typeAheadAriaLabel: "Select a model to include...", placeholderText: "Select a model to include...", onToggle: setModelSelectOpen, onClear: () => setSelectedPathRelativeToThisDmn(undefined), onSelect: (e, path) => {
                                                if (typeof path !== "string") {
                                                    throw new Error(`Invalid path for an included model ${JSON.stringify(path)}`);
                                                }
                                                setSelectedPathRelativeToThisDmn(path);
                                                setModelSelectOpen(false);
                                            }, selections: selectedPathRelativeToThisDmn, isOpen: isModelSelectOpen, "aria-labelledby": "Included model selector", isGrouped: true, children: [_jsx(SelectGroup, { label: "DMN", children: (((_b = dmnPathsNotYetIncluded === null || dmnPathsNotYetIncluded === void 0 ? void 0 : dmnPathsNotYetIncluded.length) !== null && _b !== void 0 ? _b : 0) > 0 &&
                                                        (dmnPathsNotYetIncluded === null || dmnPathsNotYetIncluded === void 0 ? void 0 : dmnPathsNotYetIncluded.map((p) => {
                                                            var _a;
                                                            const normalizedPosixPathRelativeToTheWorkspaceRoot = (_a = onRequestToResolvePath === null || onRequestToResolvePath === void 0 ? void 0 : onRequestToResolvePath(p)) !== null && _a !== void 0 ? _a : p;
                                                            return (_jsx(SelectOption, { description: dirname(normalizedPosixPathRelativeToTheWorkspaceRoot), value: p, children: basename(normalizedPosixPathRelativeToTheWorkspaceRoot) }, normalizedPosixPathRelativeToTheWorkspaceRoot));
                                                        }))) || (_jsx(SelectOption, { isDisabled: true, description: "", value: "", children: _jsx("i", { children: "None" }) }, "none-dmn")) }, "DMN"), _jsx(Divider, {}, "divider"), _jsx(SelectGroup, { label: "PMML", children: (((_c = pmmlPathsNotYetIncluded === null || pmmlPathsNotYetIncluded === void 0 ? void 0 : pmmlPathsNotYetIncluded.length) !== null && _c !== void 0 ? _c : 0) > 0 &&
                                                        (pmmlPathsNotYetIncluded === null || pmmlPathsNotYetIncluded === void 0 ? void 0 : pmmlPathsNotYetIncluded.map((p) => {
                                                            var _a;
                                                            const normalizedPosixPathRelativeToTheWorkspaceRoot = (_a = onRequestToResolvePath === null || onRequestToResolvePath === void 0 ? void 0 : onRequestToResolvePath(p)) !== null && _a !== void 0 ? _a : p;
                                                            return (_jsx(SelectOption, { description: dirname(normalizedPosixPathRelativeToTheWorkspaceRoot), value: p, children: basename(normalizedPosixPathRelativeToTheWorkspaceRoot) }, normalizedPosixPathRelativeToTheWorkspaceRoot));
                                                        }))) || (_jsx(SelectOption, { isDisabled: true, description: "", value: "", children: _jsx("i", { children: "None" }) }, "none-pmml")) }, "PMML")] }) }), _jsx(FormGroup, { label: "Name", children: _jsx(InlineFeelNameInput, { validate: DMN15_SPEC.IMPORT.name.isValid, placeholder: EMPTY_IMPORT_NAME_NAMESPACE_IDENTIFIER, isPlain: false, id: generateUuid(), name: importName, isReadOnly: false, shouldCommitOnBlur: true, className: "pf-c-form-control", onRenamed: setImportName, allUniqueNames: getAllUniqueNames }) }), _jsx("br", {}), selectedModelError !== undefined && (_jsx("span", { className: "kie-dmn-editor--selected-model-to-include-error", children: selectedModelError }))] })] }))) || (_jsx(_Fragment, { children: (((_d = modelPathRelativeToThisDmn === null || modelPathRelativeToThisDmn === void 0 ? void 0 : modelPathRelativeToThisDmn.length) !== null && _d !== void 0 ? _d : 0) > 0 &&
                            `All models available${externalContextName ? ` in '${externalContextName}' ` : ` `}are already included.`) ||
                            `There's no available models${externalContextName ? ` in '${externalContextName}' ` : ` `}to be included.` })) }))) || _jsx(_Fragment, { children: "Loading..." }) }), thisDmnsImports.length > 0 && (_jsx(_Fragment, { children: _jsxs(PageSection, { style: { padding: "24px" }, children: [_jsx(Button, { isDisabled: settings.isReadOnly, onClick: openModal, variant: ButtonVariant.primary, children: "Include model" }), _jsx("br", {}), _jsx("br", {}), _jsx(Divider, { inset: { default: "insetMd" } }), _jsx("br", {}), _jsx(Gallery, { hasGutter: true, minWidths: { xl: "calc(25% - 1rem)", md: "calc(33% - 1rem)", sm: "100%" }, children: thisDmnsImports.flatMap((dmnImport, index) => {
                                var _a;
                                const externalModel = (_a = externalModelsByNamespace === null || externalModelsByNamespace === void 0 ? void 0 : externalModelsByNamespace[getNamespaceOfDmnImport({ dmnImport: dmnImport })]) !== null && _a !== void 0 ? _a : (!isModalOpen && index === thisDmnsImports.length - 1 ? selectedModel : undefined);
                                return !externalModel ? (_jsx(IncludedModelCard, { _import: dmnImport, index: index, externalModel: undefined, isReadOnly: settings.isReadOnly }, dmnImport["@_id"])) : (_jsx(IncludedModelCard, { _import: dmnImport, index: index, externalModel: externalModel, isReadOnly: settings.isReadOnly }, dmnImport["@_id"]));
                            }) })] }) })), thisDmnsImports.length <= 0 && (_jsx(Flex, { justifyContent: { default: "justifyContentCenter" }, style: { marginTop: "100px" }, children: _jsxs(EmptyState, { style: { maxWidth: "1280px" }, children: [_jsx(EmptyStateIcon, { icon: CubesIcon }), _jsx(Title, { size: "lg", headingLevel: "h4", children: "No external models have been included." }), _jsx(EmptyStateBody, { children: "Included models are externally defined models that have been added to this DMN file. Included DMN models have their decision requirements diagram (DRD) or decision requirements graph (DRG) components available in this DMN file. Included PMML models can be invoked through DMN Boxed Functions, usually inside Business Knowledge Model nodes (BKMs)" }), !settings.isReadOnly && (_jsx(Button, { onClick: openModal, variant: ButtonVariant.primary, children: "Include model" }))] }) }))] }));
}
function IncludedModelCard({ _import, index, externalModel, isReadOnly, }) {
    var _a;
    const { externalModelsByNamespace } = useExternalModels();
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const { onRequestToJumpToPath, onRequestToResolvePath } = useDmnEditor();
    const remove = useCallback((index) => {
        setRemovePopoverOpen(false);
        dmnEditorStoreApi.setState((state) => {
            const externalModelTypesByNamespace = state
                .computed(state)
                .getDirectlyIncludedExternalModelsByNamespace(externalModelsByNamespace);
            deleteImport({
                definitions: state.dmn.model.definitions,
                __readonly_index: index,
                __readonly_externalModelTypesByNamespace: externalModelTypesByNamespace,
                __readonly_externalModelsByNamespace: externalModelsByNamespace,
            });
        });
    }, [dmnEditorStoreApi, externalModelsByNamespace]);
    const externalDmnsByNamespace = useDmnEditorStore((s) => s.computed(s).getDirectlyIncludedExternalModelsByNamespace(externalModelsByNamespace).dmns);
    const externalModelsByNamespaceMap = useMemo(() => {
        const externalModels = new Map();
        for (const [key, externalDmn] of externalDmnsByNamespace) {
            externalModels.set(key, externalDmn.model);
        }
        return externalModels;
    }, [externalDmnsByNamespace]);
    const rename = useCallback((newName) => {
        dmnEditorStoreApi.setState((state) => {
            renameImport({
                definitions: state.dmn.model.definitions,
                index,
                newName,
                allTopLevelDataTypesByFeelName: state.computed(state).getDataTypes(externalModelsByNamespace)
                    .allTopLevelDataTypesByFeelName,
                externalModelsByNamespaceMap,
            });
        });
    }, [dmnEditorStoreApi, externalModelsByNamespace, externalModelsByNamespaceMap, index]);
    const extension = useMemo(() => {
        if (allDmnImportNamespaces.has(_import["@_importType"])) {
            return "dmn";
        }
        else if (allPmmlImportNamespaces.has(_import["@_importType"])) {
            return "pmml";
        }
        else {
            return "Unknwon";
        }
    }, [_import]);
    const title = useMemo(() => {
        if (externalModel === undefined) {
            return "";
        }
        if (externalModel.type === "dmn") {
            return externalModel.model.definitions["@_name"];
        }
        else if (externalModel.type === "pmml") {
            return "";
        }
    }, [externalModel]);
    const pathDisplayed = useMemo(() => {
        var _a;
        if (externalModel !== undefined) {
            return ((_a = onRequestToResolvePath === null || onRequestToResolvePath === void 0 ? void 0 : onRequestToResolvePath(externalModel.normalizedPosixPathRelativeToTheOpenFile)) !== null && _a !== void 0 ? _a : externalModel.normalizedPosixPathRelativeToTheOpenFile);
        }
    }, [onRequestToResolvePath, externalModel]);
    const [isRemovePopoverOpen, setRemovePopoverOpen] = useState(false);
    const [isConfirmationPopoverOpen, setConfirmationPopoverOpen] = useState(false);
    const shouldRenderConfirmationMessage = useMemo(() => isRemovePopoverOpen && isConfirmationPopoverOpen, [isConfirmationPopoverOpen, isRemovePopoverOpen]);
    return (_jsxs(Card, { isHoverable: true, isCompact: false, children: [_jsxs(CardHeader, { children: [!isReadOnly && (_jsx(CardActions, { children: _jsx(Popover, { bodyContent: shouldRenderConfirmationMessage ? (_jsxs(Alert, { isInline: true, variant: AlertVariant.warning, title: "This action have major impact to your model", actionClose: _jsx(AlertActionCloseButton, { onClose: () => {
                                        setRemovePopoverOpen(false);
                                        setConfirmationPopoverOpen(false);
                                    } }), actionLinks: _jsx(_Fragment, { children: _jsx(AlertActionLink, { onClick: (ev) => {
                                            remove(index);
                                            ev.stopPropagation();
                                            ev.preventDefault();
                                        }, variant: "link", style: { color: "var(--pf-global--danger-color--200)", fontWeight: "bold" }, children: `Yes, remove included ${extension.toUpperCase()}` }) }), children: [extension === "dmn" && (_jsx(_Fragment, { children: "Removing an included DMN will erase all its imported nodes and connected edges from your model. The references to item definitions, Business Knowledge Model functions, and Decision expressions will remain, requiring to be manually removed." })), extension === "pmml" && (_jsx(_Fragment, { children: "Removing an included PMML will not erase references on Boxed Function expressions, requiring it to be manually removed." }))] })) : (_jsxs(Button, { variant: "plain", onClick: (ev) => {
                                    ev.stopPropagation();
                                    ev.preventDefault();
                                    if (isReadOnly) {
                                        return;
                                    }
                                    setConfirmationPopoverOpen(true);
                                }, children: [_jsx(TrashIcon, {}), "  ", "Remove"] })), hasNoPadding: shouldRenderConfirmationMessage, maxWidth: shouldRenderConfirmationMessage ? "300px" : "150px", minWidth: shouldRenderConfirmationMessage ? "300px" : "150px", isVisible: isRemovePopoverOpen, showClose: false, shouldClose: () => {
                                setRemovePopoverOpen(false);
                                setConfirmationPopoverOpen(false);
                            }, position: PopoverPosition.bottom, shouldOpen: () => setRemovePopoverOpen(true), children: _jsx("div", { className: "kie-dmn-editor--model-card-kebabtoggle-wrapper", onClick: (ev) => {
                                    ev.stopPropagation();
                                    ev.preventDefault();
                                }, children: _jsx(KebabToggle, {}) }) }) })), _jsxs(CardTitle, { children: [_jsx(InlineFeelNameInput, { placeholder: EMPTY_IMPORT_NAME_NAMESPACE_IDENTIFIER, isPlain: true, allUniqueNames: useCallback((s) => s.computed(s).getAllFeelVariableUniqueNames(), []), id: _import["@_id"], name: _import["@_name"], isReadOnly: isReadOnly, shouldCommitOnBlur: true, onRenamed: rename, validate: DMN15_SPEC.IMPORT.name.isValid }), _jsx("br", {}), _jsx("br", {}), _jsx(ExternalModelLabel, { extension: extension }), _jsx("br", {}), _jsx("br", {})] })] }), externalModel ? (_jsxs(CardBody, { children: [`${title}`, _jsx("br", {}), _jsx("br", {}), _jsx("small", { children: _jsx(Button, { variant: ButtonVariant.link, style: { paddingLeft: 0, whiteSpace: "break-spaces", textAlign: "left" }, onClick: () => {
                                onRequestToJumpToPath === null || onRequestToJumpToPath === void 0 ? void 0 : onRequestToJumpToPath(externalModel.normalizedPosixPathRelativeToTheOpenFile);
                            }, children: _jsx("i", { children: pathDisplayed }) }) })] })) : (_jsx(CardBody, { children: _jsxs(Alert, { title: "External model not found.", isInline: true, variant: AlertVariant.danger, children: [_jsx(Divider, { style: { marginTop: "16px" } }), _jsx("br", {}), _jsxs("p", { children: [_jsx("b", { children: "Namespace:" }), "\u00A0", _import["@_namespace"]] }), _jsxs("p", { children: [_jsx("b", { children: "URI:" }), "\u00A0", (_a = _import["@_locationURI"]) !== null && _a !== void 0 ? _a : _jsx("i", { children: "None" })] })] }) }))] }));
}
//# sourceMappingURL=IncludedModels.js.map