import { jsx as _jsx } from "react/jsx-runtime";
import { useMemo } from "react";
import { AlternativeInputDataNodeSvg, BkmNodeSvg, DecisionNodeSvg, DecisionServiceNodeSvg, GroupNodeSvg, InputDataNodeSvg, KnowledgeSourceNodeSvg, TextAnnotationNodeSvg, } from "../diagram/nodes/NodeSvgs";
import { switchExpression } from "@kie-tools-core/switch-expression-ts";
import { NODE_TYPES } from "../diagram/nodes/NodeTypes";
import { QuestionCircleIcon } from "@patternfly/react-icons/dist/js/icons/question-circle-icon";
const radius = 34;
const svgViewboxPadding = Math.sqrt(Math.pow(radius, 2) / 2) - radius / 2;
const nodeSvgProps = { width: 200, height: 120, x: 16, y: 48, strokeWidth: 16 };
export function RoundSvg({ children, padding, height, viewBox, }) {
    const style = useMemo(() => (padding !== undefined ? { padding, height } : { padding: `${svgViewboxPadding}px`, height }), [padding, height]);
    const nodeSvgViewboxSize = useMemo(() => {
        return viewBox !== null && viewBox !== void 0 ? viewBox : nodeSvgProps.width + 2 * nodeSvgProps.strokeWidth;
    }, [viewBox]);
    return (_jsx("svg", { className: "kie-dmn-editor--round-svg-container", viewBox: `0 0 ${nodeSvgViewboxSize} ${nodeSvgViewboxSize}`, style: style, children: children }));
}
export function NodeIcon({ isAlternativeInputDataShape, nodeType }) {
    return switchExpression(nodeType, {
        [NODE_TYPES.inputData]: isAlternativeInputDataShape ? AlternativeInputDataIcon : InputDataIcon,
        [NODE_TYPES.decision]: DecisionIcon,
        [NODE_TYPES.bkm]: BkmIcon,
        [NODE_TYPES.knowledgeSource]: KnowledgeSourceIcon,
        [NODE_TYPES.decisionService]: DecisionServiceIcon,
        [NODE_TYPES.group]: GroupIcon,
        [NODE_TYPES.textAnnotation]: TextAnnotationIcon,
        [NODE_TYPES.unknown]: UnknownIcon,
        default: () => _jsx("div", { children: "?" }),
    });
}
export function InputDataIcon(props) {
    return (_jsx(RoundSvg, { padding: props.padding, height: props.height, children: _jsx(InputDataNodeSvg, { ...nodeSvgProps, isCollection: false }) }));
}
export function AlternativeInputDataIcon(props) {
    var _a, _b;
    return (_jsx(RoundSvg, { padding: (_a = props.padding) !== null && _a !== void 0 ? _a : "0px", height: props.height, viewBox: props.viewBox, children: _jsx(AlternativeInputDataNodeSvg, { ...nodeSvgProps, isIcon: true, width: 80, height: 100, strokeWidth: 10, transform: (_b = props.transform) !== null && _b !== void 0 ? _b : "translate(80, 60)", isCollection: false }) }));
}
export function DecisionIcon() {
    return (_jsx(RoundSvg, { children: _jsx(DecisionNodeSvg, { ...nodeSvgProps, hasHiddenRequirements: false, isCollection: false }) }));
}
export function BkmIcon() {
    return (_jsx(RoundSvg, { children: _jsx(BkmNodeSvg, { ...nodeSvgProps, hasHiddenRequirements: false }) }));
}
export function KnowledgeSourceIcon() {
    return (_jsx(RoundSvg, { children: _jsx(KnowledgeSourceNodeSvg, { ...nodeSvgProps, hasHiddenRequirements: false }) }));
}
export function DecisionServiceIcon() {
    return (_jsx(RoundSvg, { children: _jsx(DecisionServiceNodeSvg, { ...nodeSvgProps, y: 12, height: nodeSvgProps.width, showSectionLabels: false, isReadOnly: true }) }));
}
export function GroupIcon() {
    return (_jsx(RoundSvg, { children: _jsx(GroupNodeSvg, { ...nodeSvgProps, y: 12, height: nodeSvgProps.width, strokeDasharray: "28,28" }) }));
}
export function TextAnnotationIcon() {
    return (_jsx(RoundSvg, { children: _jsx(TextAnnotationNodeSvg, { ...nodeSvgProps, showPlaceholder: true }) }));
}
export function UnknownIcon() {
    return (_jsx("div", { style: { display: "flex", alignItems: "center", justifyContent: "center", height: "100%" }, children: _jsx(QuestionCircleIcon, {}) }));
}
//# sourceMappingURL=Icons.js.map