import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import * as React from "react";
import * as RF from "reactflow";
import { Flex, FlexItem } from "@patternfly/react-core/dist/js/layouts/Flex";
import { AssociationPath, AuthorityRequirementPath, InformationRequirementPath, KnowledgeRequirementPath, } from "../edges/Edges";
import { InputDataNodeSvg, DecisionNodeSvg, BkmNodeSvg, DecisionServiceNodeSvg, KnowledgeSourceNodeSvg, TextAnnotationNodeSvg, GroupNodeSvg, } from "./NodeSvgs";
import { NODE_TYPES } from "./NodeTypes";
import { EDGE_TYPES } from "../edges/EdgeTypes";
import { useSettings } from "../../settings/DmnEditorSettingsContext";
const handleButtonSize = 34;
const svgViewboxPadding = Math.sqrt(Math.pow(handleButtonSize, 2) / 2) - handleButtonSize / 2;
const edgeSvgViewboxSize = 25;
const nodeSvgProps = { width: 100, height: 70, x: 0, y: 15, strokeWidth: 8 };
const nodeSvgViewboxSize = nodeSvgProps.width;
export const handleStyle = {
    display: "flex",
    position: "unset",
    transform: "unset",
};
export function OutgoingStuffNodePanel(props) {
    const settings = useSettings();
    const style = React.useMemo(() => ({
        visibility: !settings.isReadOnly && props.isVisible ? undefined : "hidden",
    }), [props.isVisible, settings.isReadOnly]);
    const getEdgeActionTitle = React.useCallback((edgeType) => {
        switch (edgeType) {
            case EDGE_TYPES.informationRequirement: {
                return "Add Information Requirement edge";
            }
            case EDGE_TYPES.knowledgeRequirement: {
                return "Add Knowledge Requirement edge";
            }
            case EDGE_TYPES.authorityRequirement: {
                return "Add Authority Requirement edge";
            }
            case EDGE_TYPES.association: {
                return "Add Association edge";
            }
            default: {
                throw new Error("Add Unknown edge type");
            }
        }
    }, []);
    const getNodeActionTitle = React.useCallback((nodeType) => {
        switch (nodeType) {
            case NODE_TYPES.decision: {
                return "Add Decision node";
            }
            case NODE_TYPES.bkm: {
                return "Add BKM node";
            }
            case NODE_TYPES.knowledgeSource: {
                return "Add Knowledge Source node";
            }
            case NODE_TYPES.textAnnotation: {
                return "Add Text Annotation node";
            }
            default: {
                throw new Error("Add Unknown node type");
            }
        }
    }, []);
    return (_jsx(_Fragment, { children: _jsxs(Flex, { className: "kie-dmn-editor--outgoing-stuff-node-panel", style: style, children: [props.edgeTypes.length > 0 && (_jsx(FlexItem, { children: props.edgeTypes.map((edgeType) => (_jsx(RF.Handle, { id: edgeType, isConnectableEnd: false, type: "source", style: handleStyle, position: RF.Position.Top, title: getEdgeActionTitle(edgeType), "data-testid": `${props.nodeHref}-add-${edgeType}`, children: _jsxs("svg", { className: "kie-dmn-editor--round-svg-container", viewBox: `0 0 ${edgeSvgViewboxSize} ${edgeSvgViewboxSize}`, style: { padding: `${svgViewboxPadding}px` }, children: [edgeType === EDGE_TYPES.informationRequirement && (_jsx(InformationRequirementPath, { d: `M2,${edgeSvgViewboxSize - 2} L${edgeSvgViewboxSize - 2},0` })), edgeType === EDGE_TYPES.knowledgeRequirement && (_jsx(KnowledgeRequirementPath, { d: `M2,${edgeSvgViewboxSize - 2} L${edgeSvgViewboxSize - 2},0` })), edgeType === EDGE_TYPES.authorityRequirement && (_jsx(AuthorityRequirementPath, { d: `M2,${edgeSvgViewboxSize - 2} L${edgeSvgViewboxSize - 2},2`, centerToConnectionPoint: false })), edgeType === EDGE_TYPES.association && (_jsx(AssociationPath, { d: `M2,${edgeSvgViewboxSize - 2} L${edgeSvgViewboxSize},0`, strokeWidth: 2 }))] }) }, edgeType))) })), props.nodeTypes.length > 0 && (_jsx(FlexItem, { children: props.nodeTypes.map((nodeType) => (_jsx(RF.Handle, { id: nodeType, isConnectableEnd: false, type: "source", style: handleStyle, position: RF.Position.Top, title: getNodeActionTitle(nodeType), "data-testid": `${props.nodeHref}-add-${nodeType}`, children: _jsxs("svg", { className: "kie-dmn-editor--round-svg-container", viewBox: `0 0 ${nodeSvgViewboxSize} ${nodeSvgViewboxSize}`, style: { padding: `${svgViewboxPadding}px` }, children: [nodeType === NODE_TYPES.inputData && _jsx(InputDataNodeSvg, { ...nodeSvgProps, isCollection: false }), nodeType === NODE_TYPES.decision && (_jsx(DecisionNodeSvg, { ...nodeSvgProps, isCollection: false, hasHiddenRequirements: false })), nodeType === NODE_TYPES.bkm && _jsx(BkmNodeSvg, { ...nodeSvgProps, hasHiddenRequirements: false }), nodeType === NODE_TYPES.decisionService && (_jsx(DecisionServiceNodeSvg, { ...nodeSvgProps, y: 0, height: nodeSvgProps.width, showSectionLabels: true, isReadOnly: true })), nodeType === NODE_TYPES.knowledgeSource && (_jsx(KnowledgeSourceNodeSvg, { ...nodeSvgProps, hasHiddenRequirements: false })), nodeType === NODE_TYPES.textAnnotation && _jsx(TextAnnotationNodeSvg, { ...nodeSvgProps }), nodeType === NODE_TYPES.group && _jsx(GroupNodeSvg, { ...nodeSvgProps })] }) }, nodeType))) }))] }) }));
}
//# sourceMappingURL=OutgoingStuffNodePanel.js.map