import { DMN15__tBusinessKnowledgeModel, DMN15__tDecision, DMN15__tDecisionService, DMN15__tDefinitions, DMN15__tGroup, DMN15__tInputData, DMN15__tKnowledgeSource, DMN15__tTextAnnotation, DMNDI15__DMNShape } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/ts-gen/types";
import { XmlQName } from "@kie-tools/xml-parser-ts/dist/qNames";
import { Normalized } from "@kie-tools/dmn-marshaller/dist/normalization/normalize";
import * as React from "react";
import * as RF from "reactflow";
import { OnCreateDataType } from "../../dataTypes/TypeRefSelector";
import { SnapGrid } from "../../store/Store";
import { Unpacked } from "../../tsExt/tsExt";
import { NodeType } from "../connections/graphStructure";
import { NODE_TYPES } from "./NodeTypes";
export type ElementFilter<E extends {
    __$$element: string;
}, Filter extends string> = E extends any ? E["__$$element"] extends Filter ? E : never : never;
export type NodeDmnObjects = null | Unpacked<Normalized<DMN15__tDefinitions>["drgElement"]> | ElementFilter<Unpacked<Normalized<DMN15__tDefinitions>["artifact"]>, "textAnnotation" | "group">;
export type DmnDiagramNodeData<T extends NodeDmnObjects = NodeDmnObjects> = {
    dmnObjectNamespace: string | undefined;
    dmnObjectQName: XmlQName;
    dmnObject: T;
    shape: Normalized<DMNDI15__DMNShape> & {
        index: number;
    };
    index: number;
    hasHiddenRequirements: boolean;
    parentRfNode: RF.Node<DmnDiagramNodeData> | undefined;
};
export declare const InputDataNode: React.MemoExoticComponent<({ data: { dmnObject: inputData, shape, index, dmnObjectQName, dmnObjectNamespace }, selected, dragging, zIndex, type, id, }: RF.NodeProps<DmnDiagramNodeData<Normalized<DMN15__tInputData> & {
    __$$element: "inputData";
}>>) => JSX.Element>;
export declare const DecisionNode: React.MemoExoticComponent<({ data: { parentRfNode, dmnObject: decision, shape, index, dmnObjectQName, dmnObjectNamespace, hasHiddenRequirements, }, selected, dragging, zIndex, type, id, }: RF.NodeProps<DmnDiagramNodeData<Normalized<DMN15__tDecision> & {
    __$$element: "decision";
}>>) => JSX.Element>;
export declare const BkmNode: React.MemoExoticComponent<({ data: { dmnObject: bkm, shape, index, dmnObjectQName, dmnObjectNamespace, hasHiddenRequirements }, selected, dragging, zIndex, type, id, }: RF.NodeProps<DmnDiagramNodeData<Normalized<DMN15__tBusinessKnowledgeModel> & {
    __$$element: "businessKnowledgeModel";
}>>) => JSX.Element>;
export declare const KnowledgeSourceNode: React.MemoExoticComponent<({ data: { dmnObject: knowledgeSource, shape, index, dmnObjectQName, hasHiddenRequirements }, selected, dragging, zIndex, type, id, }: RF.NodeProps<DmnDiagramNodeData<Normalized<DMN15__tKnowledgeSource> & {
    __$$element: "knowledgeSource";
}>>) => JSX.Element>;
export declare const TextAnnotationNode: React.MemoExoticComponent<({ data: { dmnObject: textAnnotation, shape, index }, selected, dragging, zIndex, type, id, }: RF.NodeProps<DmnDiagramNodeData<Normalized<DMN15__tTextAnnotation> & {
    __$$element: "textAnnotation";
}>>) => JSX.Element>;
export declare const DecisionServiceNode: React.MemoExoticComponent<({ data: { dmnObject: decisionService, shape, index, dmnObjectQName, dmnObjectNamespace }, selected, dragging, zIndex, type, id, }: RF.NodeProps<DmnDiagramNodeData<Normalized<DMN15__tDecisionService> & {
    __$$element: "decisionService";
}>>) => JSX.Element>;
export declare const GroupNode: React.MemoExoticComponent<({ data: { dmnObject: group, shape, index }, selected, dragging, type, id, }: RF.NodeProps<DmnDiagramNodeData<Normalized<DMN15__tGroup> & {
    __$$element: "group";
}>>) => JSX.Element>;
export declare const UnknownNode: React.MemoExoticComponent<({ data: { shape }, selected, dragging, type, id }: RF.NodeProps<DmnDiagramNodeData<null>>) => JSX.Element>;
export declare function EmptyLabel(): JSX.Element;
type NodeResizeHandleProps = {
    snapGrid: SnapGrid;
    nodeId: string;
    nodeName: string;
    nodeShapeIndex: number;
} & ({
    nodeType: Extract<NodeType, typeof NODE_TYPES.inputData>;
    isAlternativeInputDataShape: boolean;
} | {
    nodeType: Exclude<NodeType, typeof NODE_TYPES.inputData>;
});
export declare function NodeResizerHandle(props: NodeResizeHandleProps): JSX.Element;
export declare function useConnection(nodeId: string): {
    source: string | null;
    target: string | null;
    sourceHandle: string | null;
    targetHandle: null;
};
export declare function useConnectionTargetStatus(nodeId: string, shouldActLikeHovered: boolean): {
    isTargeted: boolean;
    isValidConnectionTarget: boolean;
};
export declare function useNodeClassName(isValidConnectionTarget: boolean, nodeId: string): "normal" | "dimmed" | "drop-target" | "drop-target-invalid";
export declare function useDataTypeCreationCallbackForNodes(index: number, drgElementName: string): OnCreateDataType;
export {};
//# sourceMappingURL=Nodes.d.ts.map