export function getAdjMatrix(edges) {
    var _a, _b;
    var _c, _d;
    const __adjMatrix = {};
    for (const e of edges) {
        (_a = __adjMatrix[_c = e.sourceId]) !== null && _a !== void 0 ? _a : (__adjMatrix[_c] = {});
        (_b = __adjMatrix[_d = e.targetId]) !== null && _b !== void 0 ? _b : (__adjMatrix[_d] = {});
        __adjMatrix[e.sourceId][e.targetId] = { direction: "up", edge: e };
        __adjMatrix[e.targetId][e.sourceId] = { direction: "down", edge: e };
    }
    return __adjMatrix;
}
export function traverse(__adjMatrix, originalStartingNodeIds, curNodeIds, traversalDirection, nodeVisitor, edgeVisitor, visited = new Set()) {
    if (curNodeIds.length <= 0) {
        return;
    }
    const nextNodeIds = curNodeIds.flatMap((curNodeId) => {
        var _a;
        if (visited.has(curNodeId)) {
            return [];
        }
        if (!originalStartingNodeIds.has(curNodeId)) {
            nodeVisitor === null || nodeVisitor === void 0 ? void 0 : nodeVisitor(curNodeId, traversalDirection);
        }
        const curNodeAdjs = (_a = __adjMatrix[curNodeId]) !== null && _a !== void 0 ? _a : {};
        return Object.keys(curNodeAdjs).flatMap((adjNodeId) => {
            const { edge, direction: edgeDirection } = curNodeAdjs[adjNodeId];
            if (traversalDirection !== edgeDirection) {
                return [];
            }
            visited.add(curNodeId);
            if (!(originalStartingNodeIds.has(edge.sourceId) && originalStartingNodeIds.has(edge.targetId))) {
                edgeVisitor === null || edgeVisitor === void 0 ? void 0 : edgeVisitor(edge, traversalDirection);
            }
            return [adjNodeId];
        });
    });
    traverse(__adjMatrix, originalStartingNodeIds, nextNodeIds, traversalDirection, nodeVisitor, edgeVisitor, visited);
}
export function buildHierarchy({ nodeId, edges }) {
    if (!nodeId) {
        return { dependencies: new Set(), dependents: new Set() };
    }
    const selected = [nodeId];
    const __selectedSet = new Set(selected);
    const __adjMatrix = getAdjMatrix(edges);
    const down = new Set();
    traverse(__adjMatrix, __selectedSet, selected, "down", (nodeId) => {
        down.add(nodeId);
    });
    const up = new Set();
    traverse(__adjMatrix, __selectedSet, selected, "up", (nodeId) => {
        up.add(nodeId);
    });
    return { dependencies: down, dependents: up };
}
//# sourceMappingURL=graph.js.map