import { createElement as _createElement } from "react";
import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { useCallback, useMemo, useState } from "react";
import { getNewDmnIdRandomizer } from "@kie-tools/dmn-marshaller/dist/idRandomizer/dmnIdRandomizer";
import { Drawer, DrawerContent, DrawerContentBody, DrawerPanelContent, } from "@patternfly/react-core/dist/js/components/Drawer";
import { Flex } from "@patternfly/react-core/dist/js/layouts/Flex";
import { InfrastructureIcon } from "@patternfly/react-icons/dist/js/icons/infrastructure-icon";
import { PlusCircleIcon } from "@patternfly/react-icons/dist/js/icons/plus-circle-icon";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { DataTypesEmptyState } from "./DataTypesEmptyState";
import { DataTypePanel } from "./DataTypePanel";
import { findDataTypeById, isStruct } from "./DataTypeSpec";
import { DataTypeName } from "./DataTypeName";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import { DMN15_SPEC } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/Dmn15Spec";
import { invalidInlineFeelNameStyle } from "../feel/InlineFeelNameInput";
import { Dropdown, DropdownItem, DropdownPosition, DropdownToggle, DropdownToggleAction, } from "@patternfly/react-core/dist/js/components/Dropdown";
import { PasteIcon } from "@patternfly/react-icons/dist/js/icons/paste-icon";
import { InputGroup } from "@patternfly/react-core/dist/js/components/InputGroup";
import { SearchInput } from "@patternfly/react-core/dist/js/components/SearchInput";
import { ImportJavaClassesWizard, ImportJavaClassesI18nDictionariesProvider, } from "@kie-tools/import-java-classes-component";
import { DMN_EDITOR_DATA_TYPES_CLIPBOARD_MIME_TYPE, getClipboard, } from "../clipboard/Clipboard";
import { addTopLevelItemDefinition as _addTopLevelItemDefinition } from "../mutations/addTopLevelItemDefinition";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
import { useSettings } from "../settings/DmnEditorSettingsContext";
import { ImportJavaClassesDropdownItem, ImportJavaClassNameConflictsModal } from "./ImportJavaClasses";
import { useImportJavaClasses } from "./useImportJavaClasses";
export function DataTypes() {
    const thisDmnsNamespace = useDmnEditorStore((s) => s.dmn.model.definitions["@_namespace"]);
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const activeItemDefinitionId = useDmnEditorStore((s) => s.dataTypesEditor.activeItemDefinitionId);
    const { isReadOnly, isImportDataTypesFromJavaClassesSupported, javaCodeCompletionService } = useSettings();
    const [filter, setFilter] = useState("");
    const { externalModelsByNamespace } = useExternalModels();
    const allTopLevelItemDefinitionUniqueNames = useDmnEditorStore((s) => s.computed(s).getDataTypes(externalModelsByNamespace).allTopLevelItemDefinitionUniqueNames);
    const allDataTypesById = useDmnEditorStore((s) => s.computed(s).getDataTypes(externalModelsByNamespace).allDataTypesById);
    const dataTypesTree = useDmnEditorStore((s) => s.computed(s).getDataTypes(externalModelsByNamespace).dataTypesTree);
    const [isOpenImportJavaClassesWizard, setOpenImportJavaClassesWizard] = useState(false);
    const { conflictsClasses, handleConflictAction, handleImportJavaClasses, isConflictsOccured } = useImportJavaClasses();
    const handleImportJavaClassButtonClick = useCallback(() => {
        setOpenImportJavaClassesWizard((prevState) => !prevState);
    }, []);
    const activeDataType = useMemo(() => {
        return activeItemDefinitionId ? allDataTypesById.get(activeItemDefinitionId) : undefined;
    }, [activeItemDefinitionId, allDataTypesById]);
    const filteredTree = useMemo(() => dataTypesTree.filter(({ itemDefinition: dataType }) => dataType["@_name"].toLowerCase().includes(filter.toLowerCase())), [filter, dataTypesTree]);
    const editItemDefinition = useCallback((id, consumer) => {
        dmnEditorStoreApi.setState((state) => {
            var _a;
            var _b;
            const { itemDefinition, items, index } = findDataTypeById({
                definitions: state.dmn.model.definitions,
                itemDefinitionId: id,
                allDataTypesById,
            });
            (_a = (_b = state.dmn.model.definitions).itemDefinition) !== null && _a !== void 0 ? _a : (_b.itemDefinition = []);
            consumer(itemDefinition, items, index, state.dmn.model.definitions.itemDefinition, state);
        });
    }, [allDataTypesById, dmnEditorStoreApi]);
    const addTopLevelItemDefinition = useCallback((partial) => {
        dmnEditorStoreApi.setState((state) => {
            const newItemDefinition = _addTopLevelItemDefinition({
                definitions: state.dmn.model.definitions,
                partial,
            });
            state.dataTypesEditor.activeItemDefinitionId = newItemDefinition["@_id"];
            state.focus.consumableId = newItemDefinition["@_id"];
        });
    }, [dmnEditorStoreApi]);
    const pasteTopLevelItemDefinition = useCallback(() => {
        if (isReadOnly) {
            return;
        }
        navigator.clipboard.readText().then((text) => {
            const clipboard = getClipboard(text, DMN_EDITOR_DATA_TYPES_CLIPBOARD_MIME_TYPE);
            if (!clipboard) {
                return;
            }
            getNewDmnIdRandomizer()
                .ack({
                json: clipboard.itemDefinitions,
                type: "DMN15__tDefinitions",
                attr: "itemDefinition",
            })
                .randomize({ skipAlreadyAttributedIds: false });
            for (const itemDefinition of clipboard.itemDefinitions) {
                addTopLevelItemDefinition(itemDefinition);
            }
        });
    }, [addTopLevelItemDefinition, isReadOnly]);
    const [isAddDataTypeDropdownOpen, setAddDataTypeDropdownOpen] = useState(false);
    const extraPropsForDropdownToggleAction = { title: "New Data Type" };
    const addDataTypesDropdownItems = useMemo(() => {
        const dropdownItems = [
            _jsx(DropdownItem, { onClick: () => pasteTopLevelItemDefinition(), style: { minWidth: "240px" }, icon: _jsx(PasteIcon, {}), children: "Paste" }, "paste"),
        ];
        if (isImportDataTypesFromJavaClassesSupported && javaCodeCompletionService) {
            dropdownItems.unshift(_jsx(ImportJavaClassesI18nDictionariesProvider, { children: _jsx(ImportJavaClassesDropdownItem, { javaCodeCompletionService: javaCodeCompletionService, onClick: handleImportJavaClassButtonClick }) }, "import-java-classes"));
        }
        return dropdownItems;
    }, [
        isImportDataTypesFromJavaClassesSupported,
        javaCodeCompletionService,
        handleImportJavaClassButtonClick,
        pasteTopLevelItemDefinition,
    ]);
    return (_jsx(_Fragment, { children: (dataTypesTree.length <= 0 && (_jsx(DataTypesEmptyState, { onAdd: () => addTopLevelItemDefinition({ typeRef: undefined }), onPaste: pasteTopLevelItemDefinition }))) || (_jsx(Drawer, { isExpanded: true, isInline: true, position: "left", className: "kie-dmn-editor--data-types-container", children: _jsx(DrawerContent, { panelContent: _jsxs(DrawerPanelContent, { isResizable: true, minSize: "300px", defaultSize: "400px", "data-testid": "kie-tools--dmn-editor--data-types-list", children: [_jsx(Flex, { justifyContent: { default: "justifyContentSpaceBetween" }, alignItems: { default: "alignItemsCenter" }, className: "kie-dmn-editor--data-types-filter kie-dmn-editor--sticky-top-glass-header", children: _jsxs(InputGroup, { children: [_jsx(SearchInput, { placeholder: "Filter...", value: filter, onChange: (_event, value) => setFilter(value), onClear: () => setFilter("") }), !isReadOnly && (_jsx(Dropdown, { onSelect: () => setAddDataTypeDropdownOpen(false), menuAppendTo: document.body, toggle: _jsx(DropdownToggle, { id: "add-data-type-toggle", splitButtonItems: [
                                                _createElement(DropdownToggleAction, { ...extraPropsForDropdownToggleAction, key: "add-data-type-action", "aria-label": "Add Data Type", onClick: () => addTopLevelItemDefinition({ typeRef: undefined }) },
                                                    _jsx(PlusCircleIcon, {})),
                                            ], splitButtonVariant: "action", onToggle: setAddDataTypeDropdownOpen }), position: DropdownPosition.right, isOpen: isAddDataTypeDropdownOpen, dropdownItems: addDataTypesDropdownItems }))] }) }), _jsx("div", { className: `kie-dmn-editor--data-types-nav`, children: filteredTree.map(({ namespace, itemDefinition, feelName }) => {
                                var _a;
                                const isActive = itemDefinition["@_id"] === (activeDataType === null || activeDataType === void 0 ? void 0 : activeDataType.itemDefinition["@_id"]) ||
                                    ((_a = activeDataType === null || activeDataType === void 0 ? void 0 : activeDataType.parents.has(itemDefinition["@_id"])) !== null && _a !== void 0 ? _a : false);
                                return (_jsxs(Flex, { flexWrap: { default: "nowrap" }, spaceItems: { default: "spaceItemsNone" }, onClick: () => dmnEditorStoreApi.setState((state) => {
                                        state.dataTypesEditor.activeItemDefinitionId = itemDefinition["@_id"];
                                    }), justifyContent: { default: "justifyContentFlexStart" }, alignItems: { default: "alignItemsCenter" }, className: `kie-dmn-editor--data-types-nav-item ${isActive ? "active" : ""}`, children: [_jsx(InfrastructureIcon, { style: { display: "inline", opacity: isStruct(itemDefinition) ? 1 : 0, minWidth: "1em" } }), (namespace === thisDmnsNamespace && (_jsx(DataTypeName, { relativeToNamespace: thisDmnsNamespace, isReadOnly: isReadOnly || namespace !== thisDmnsNamespace, itemDefinition: itemDefinition, isActive: isActive, editMode: "double-click", enableAutoFocusing: false, onGetAllUniqueNames: () => allTopLevelItemDefinitionUniqueNames }))) || (_jsxs(_Fragment, { children: [_jsx(Label, { style: { marginLeft: "8px" }, children: "External" }), _jsx("div", { className: `kie-dmn-editor--editable-node-name-input top-left grow`, style: DMN15_SPEC.namedElement.isValidName(itemDefinition["@_id"], feelName, allTopLevelItemDefinitionUniqueNames)
                                                        ? {}
                                                        : invalidInlineFeelNameStyle, children: `${feelName}` })] }))] }, itemDefinition["@_id"]));
                            }) })] }), children: _jsxs(DrawerContentBody, { children: [activeDataType && (_jsx(DataTypePanel, { isReadOnly: isReadOnly || activeDataType.namespace !== thisDmnsNamespace, dataType: activeDataType, allDataTypesById: allDataTypesById, editItemDefinition: editItemDefinition })), isOpenImportJavaClassesWizard && javaCodeCompletionService && (_jsx(ImportJavaClassesI18nDictionariesProvider, { children: _jsx(ImportJavaClassesWizard, { javaCodeCompletionService: javaCodeCompletionService, isOpen: isOpenImportJavaClassesWizard, onSave: handleImportJavaClasses, onClose: handleImportJavaClassButtonClick }) })), isConflictsOccured && (conflictsClasses === null || conflictsClasses === void 0 ? void 0 : conflictsClasses.length) > 0 && (_jsx(ImportJavaClassNameConflictsModal, { isOpen: isConflictsOccured, handleConfirm: handleConflictAction, confliectedJavaClasses: conflictsClasses }))] }) }) })) }));
}
//# sourceMappingURL=DataTypes.js.map