import { generateUuid, DmnBuiltInDataType } from "@kie-tools/boxed-expression-component/dist/api";
import { DMN15_SPEC } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/Dmn15Spec";
export function findDataTypeById({ definitions, itemDefinitionId, allDataTypesById, }) {
    var _a;
    const indexesPath = [];
    let current = allDataTypesById.get(itemDefinitionId);
    do {
        indexesPath.unshift(current.index);
        current = current.parentId ? allDataTypesById.get(current.parentId) : undefined;
    } while (current);
    const last = indexesPath.pop();
    (_a = definitions.itemDefinition) !== null && _a !== void 0 ? _a : (definitions.itemDefinition = []);
    let items = definitions.itemDefinition;
    for (const i of indexesPath) {
        items = items[i].itemComponent;
    }
    const itemDefinition = items[last];
    return { items, itemDefinition, index: last };
}
export function getNewItemDefinition(partial) {
    return {
        "@_id": generateUuid(),
        "@_name": "New data type",
        "@_isCollection": false,
        "@_typeLanguage": DMN15_SPEC.typeLanguage.default,
        ...(partial !== null && partial !== void 0 ? partial : {}),
    };
}
export function isCollection(itemDefinition) {
    var _a;
    return (_a = itemDefinition["@_isCollection"]) !== null && _a !== void 0 ? _a : false;
}
export function isStruct(itemDefinition) {
    return !itemDefinition.typeRef && !!itemDefinition.itemComponent;
}
export const constrainableBuiltInFeelTypes = new Map([
    [DmnBuiltInDataType.Any, ["expression"]],
    [DmnBuiltInDataType.Boolean, []],
    [DmnBuiltInDataType.Context, []],
    [DmnBuiltInDataType.Number, ["expression", "enumeration", "range"]],
    [DmnBuiltInDataType.String, ["expression", "enumeration", "range"]],
    [DmnBuiltInDataType.DateTimeDuration, ["expression", "enumeration", "range"]],
    [DmnBuiltInDataType.YearsMonthsDuration, ["expression", "enumeration", "range"]],
    [DmnBuiltInDataType.Date, ["expression", "enumeration", "range"]],
    [DmnBuiltInDataType.Time, ["expression", "enumeration", "range"]],
    [DmnBuiltInDataType.DateTime, ["expression", "enumeration", "range"]],
]);
export function canHaveConstraints(itemDefinition) {
    var _a, _b, _c;
    return (isCollection(itemDefinition) ||
        (!isStruct(itemDefinition) &&
            ((_c = (_b = constrainableBuiltInFeelTypes.get((_a = itemDefinition.typeRef) === null || _a === void 0 ? void 0 : _a.__$$text)) === null || _b === void 0 ? void 0 : _b.length) !== null && _c !== void 0 ? _c : 0) > 0));
}
export function traverseItemDefinitions(items, consumer) {
    var _a, _b;
    for (let i = 0; i < ((_a = items.length) !== null && _a !== void 0 ? _a : 0); i++) {
        consumer(items[i]);
        traverseItemDefinitions((_b = items[i].itemComponent) !== null && _b !== void 0 ? _b : [], consumer);
    }
}
export function traverseTypeRefedInExpressionHolders(expressionHolder, consumer) {
    var _a;
    if (expressionHolder.__$$element === "decision") {
        if (expressionHolder.expression) {
            traverseTypeRefedInExpressions(expressionHolder.expression, (_a = expressionHolder.expression) === null || _a === void 0 ? void 0 : _a.__$$element, consumer);
        }
    }
    else if (expressionHolder.__$$element === "businessKnowledgeModel") {
        if (expressionHolder.encapsulatedLogic) {
            traverseTypeRefedInExpressions(expressionHolder.encapsulatedLogic, "functionDefinition", consumer);
        }
    }
    else {
        throw new Error(`Unknown type of expression holder '${expressionHolder.__$$element}'`);
    }
}
export function traverseTypeRefedInExpressions(expression, __$$element, consumer) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v;
    if (!expression || !__$$element) {
        return;
    }
    consumer(expression);
    if (__$$element === "literalExpression") {
    }
    else if (__$$element === "decisionTable") {
        for (const e of (_a = expression.input) !== null && _a !== void 0 ? _a : []) {
            traverseTypeRefedInExpressions(e.inputExpression, "literalExpression", consumer);
        }
        for (const e of (_b = expression.output) !== null && _b !== void 0 ? _b : []) {
            consumer(e);
            if (e.defaultOutputEntry) {
                consumer(e.defaultOutputEntry);
            }
            if (e.outputValues) {
                consumer(e.outputValues);
            }
        }
    }
    else if (__$$element === "relation") {
        for (const e of (_c = expression.column) !== null && _c !== void 0 ? _c : []) {
            consumer(e);
        }
    }
    else if (__$$element === "list") {
        for (const e of (_d = expression.expression) !== null && _d !== void 0 ? _d : []) {
            traverseTypeRefedInExpressions(e, e.__$$element, consumer);
        }
    }
    else if (__$$element === "context") {
        for (const e of (_e = expression.contextEntry) !== null && _e !== void 0 ? _e : []) {
            if (e.variable) {
                consumer(e.variable);
            }
            traverseTypeRefedInExpressions(e.expression, (_f = e.expression) === null || _f === void 0 ? void 0 : _f.__$$element, consumer);
        }
    }
    else if (__$$element === "invocation") {
        for (const e of (_g = expression.binding) !== null && _g !== void 0 ? _g : []) {
            if (e.parameter) {
                consumer(e.parameter);
            }
            traverseTypeRefedInExpressions(e.expression, (_h = e.expression) === null || _h === void 0 ? void 0 : _h.__$$element, consumer);
        }
    }
    else if (__$$element === "functionDefinition") {
        const e = expression;
        traverseTypeRefedInExpressions(e.expression, (_j = e.expression) === null || _j === void 0 ? void 0 : _j.__$$element, consumer);
    }
    else if (__$$element === "conditional") {
        const e = expression;
        traverseTypeRefedInExpressions(e.if.expression, (_k = e.if.expression) === null || _k === void 0 ? void 0 : _k.__$$element, consumer);
        traverseTypeRefedInExpressions(e.then.expression, (_l = e.then.expression) === null || _l === void 0 ? void 0 : _l.__$$element, consumer);
        traverseTypeRefedInExpressions(e.else.expression, (_m = e.else.expression) === null || _m === void 0 ? void 0 : _m.__$$element, consumer);
    }
    else if (__$$element === "every") {
        const e = expression;
        consumer(e.in);
        traverseTypeRefedInExpressions(e.in.expression, (_o = e.in.expression) === null || _o === void 0 ? void 0 : _o.__$$element, consumer);
        traverseTypeRefedInExpressions(e.satisfies.expression, (_p = e.satisfies.expression) === null || _p === void 0 ? void 0 : _p.__$$element, consumer);
    }
    else if (__$$element === "some") {
        const e = expression;
        consumer(e.in);
        traverseTypeRefedInExpressions(e.in.expression, (_q = e.in.expression) === null || _q === void 0 ? void 0 : _q.__$$element, consumer);
        traverseTypeRefedInExpressions(e.satisfies.expression, (_r = e.satisfies.expression) === null || _r === void 0 ? void 0 : _r.__$$element, consumer);
    }
    else if (__$$element === "filter") {
        const e = expression;
        traverseTypeRefedInExpressions(e.in.expression, (_s = e.in.expression) === null || _s === void 0 ? void 0 : _s.__$$element, consumer);
        traverseTypeRefedInExpressions(e.match.expression, (_t = e.match.expression) === null || _t === void 0 ? void 0 : _t.__$$element, consumer);
    }
    else if (__$$element === "for") {
        const e = expression;
        consumer(e.in);
        traverseTypeRefedInExpressions(e.in.expression, (_u = e.in.expression) === null || _u === void 0 ? void 0 : _u.__$$element, consumer);
        traverseTypeRefedInExpressions(e.return.expression, (_v = e.return.expression) === null || _v === void 0 ? void 0 : _v.__$$element, consumer);
    }
    else {
        throw new Error(`Unknown type of expression '${__$$element}'.`);
    }
}
export function traverseExpressionsInExpressionHolders(expressionHolder, consumer) {
    var _a;
    if (expressionHolder.__$$element === "decision") {
        if (expressionHolder.expression) {
            traverseExpressions(expressionHolder.expression, (_a = expressionHolder.expression) === null || _a === void 0 ? void 0 : _a.__$$element, consumer);
        }
    }
    else if (expressionHolder.__$$element === "businessKnowledgeModel") {
        if (expressionHolder.encapsulatedLogic) {
            traverseExpressions(expressionHolder.encapsulatedLogic, "functionDefinition", consumer);
        }
    }
    else {
        throw new Error(`Unknown type of expression holder '${expressionHolder.__$$element}'`);
    }
}
export function traverseExpressions(expression, __$$element, consumer) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t;
    if (!expression || !__$$element) {
        return;
    }
    consumer(expression, __$$element);
    if (__$$element === "literalExpression") {
    }
    else if (__$$element === "decisionTable") {
        for (const e of (_a = expression.input) !== null && _a !== void 0 ? _a : []) {
            traverseExpressions(e.inputExpression, "literalExpression", consumer);
        }
    }
    else if (__$$element === "relation") {
    }
    else if (__$$element === "list") {
        for (const e of (_b = expression.expression) !== null && _b !== void 0 ? _b : []) {
            traverseExpressions(e, e.__$$element, consumer);
        }
    }
    else if (__$$element === "context") {
        for (const e of (_c = expression.contextEntry) !== null && _c !== void 0 ? _c : []) {
            traverseExpressions(e.expression, (_d = e.expression) === null || _d === void 0 ? void 0 : _d.__$$element, consumer);
        }
    }
    else if (__$$element === "invocation") {
        for (const e of (_e = expression.binding) !== null && _e !== void 0 ? _e : []) {
            traverseExpressions(e.expression, (_f = e.expression) === null || _f === void 0 ? void 0 : _f.__$$element, consumer);
        }
    }
    else if (__$$element === "functionDefinition") {
        const e = expression;
        traverseExpressions(e.expression, (_g = e.expression) === null || _g === void 0 ? void 0 : _g.__$$element, consumer);
    }
    else if (__$$element === "conditional") {
        const e = expression;
        traverseExpressions(e.if.expression, (_h = e.if.expression) === null || _h === void 0 ? void 0 : _h.__$$element, consumer);
        traverseExpressions(e.then.expression, (_j = e.then.expression) === null || _j === void 0 ? void 0 : _j.__$$element, consumer);
        traverseExpressions(e.else.expression, (_k = e.else.expression) === null || _k === void 0 ? void 0 : _k.__$$element, consumer);
    }
    else if (__$$element === "every") {
        const e = expression;
        traverseExpressions(e.in.expression, (_l = e.in.expression) === null || _l === void 0 ? void 0 : _l.__$$element, consumer);
        traverseExpressions(e.satisfies.expression, (_m = e.satisfies.expression) === null || _m === void 0 ? void 0 : _m.__$$element, consumer);
    }
    else if (__$$element === "some") {
        const e = expression;
        traverseExpressions(e.in.expression, (_o = e.in.expression) === null || _o === void 0 ? void 0 : _o.__$$element, consumer);
        traverseExpressions(e.satisfies.expression, (_p = e.satisfies.expression) === null || _p === void 0 ? void 0 : _p.__$$element, consumer);
    }
    else if (__$$element === "filter") {
        const e = expression;
        traverseExpressions(e.in.expression, (_q = e.in.expression) === null || _q === void 0 ? void 0 : _q.__$$element, consumer);
        traverseExpressions(e.match.expression, (_r = e.match.expression) === null || _r === void 0 ? void 0 : _r.__$$element, consumer);
    }
    else if (__$$element === "for") {
        const e = expression;
        traverseExpressions(e.in.expression, (_s = e.in.expression) === null || _s === void 0 ? void 0 : _s.__$$element, consumer);
        traverseExpressions(e.return.expression, (_t = e.return.expression) === null || _t === void 0 ? void 0 : _t.__$$element, consumer);
    }
    else {
        throw new Error(`Unknown type of expression '${__$$element}'.`);
    }
}
//# sourceMappingURL=DataTypeSpec.js.map