"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.treatStaticPrintCases = treatStaticPrintCases;
function treatStaticPrintCases(_a) {
    var opt = _a.opt;
    if (opt === "--help") {
        console.log("\nbuild-env is a tool to manage environment variables inside packages. \nIt maps environment variables into a JSON object and makes them accessible via JSON paths byparsing 'env/index.js' files exporting an object of type 'EnvAndVarsWithName'.\n\nUsage:\n        build-env my.custom.property\n            Prints a value.\n\n        build-env my.custom.bool --not\n            Prints a negated boolean. Will error out if value is different than 'true' or 'false'.\nor\n        build-env --print-vars\n            Prints the env var names.\n        build-env --print-vars:self\n            Same as above, but ignores composition with other envs.\n\n        build-env --print-env-json\n            Prints the JSON object for this env.\n        build-env --print-env-json:self\n            Same as above, but ignores composition with other envs.\n\n        build-env --print-dotenv\n            Prints variables assigned to values in .env format.\n        build-env --print-dotenv:self\n            Same as above, but ignores composition with other envs.\n\n        build-env --generate-empty-env-index-js\n            Generates an empty env/index.js file with the correct structure and imports.\n\n        build-env --help\n            Prints this message.\n".trim());
        process.exit(0);
    }
    if (opt === "--generate-empty-env-index-js") {
        console.log("\nconst { varsWithName, composeEnv, getOrDefault, str2bool } = require(\"@kie-tools-scripts/build-env\");\n\nmodule.exports = composeEnv([require(\"@kie-tools/root-env/env\")], {\n  vars: varsWithName({\n    MY_CUSTOM_PROPERTY: {\n      default: \"true\",\n      description: \"My custom property\"\n    }\n  }),\n  get env() {\n    return { my: { custom: { property: str2bool(getOrDefault(this.vars.MY_CUSTOM_PROPERTY)) } } };\n  },\n});\n".trim());
        process.exit(0);
    }
}
//# sourceMappingURL=static_print_cases.js.map