import { Actions } from "./Actions";
import { Builder } from "../paths";
import { getMiningSchema } from "../PMMLModelHelper";
import { validateOutput } from "../validation/Outputs";
export const OutputFieldReducer = (historyService, validationRegistry) => {
    return (state, action) => {
        switch (action.type) {
            case Actions.UpdateOutput:
                historyService.batch(state, Builder().forModel(action.payload.modelIndex).forOutput().forOutputField().build(), (draft) => {
                    const outputIndex = action.payload.outputIndex;
                    if (outputIndex >= 0 && outputIndex < draft.length) {
                        draft[outputIndex] = {
                            ...draft[outputIndex],
                            name: action.payload.outputField.name,
                            dataType: action.payload.outputField.dataType,
                            optype: action.payload.outputField.optype,
                            targetField: action.payload.outputField.targetField,
                            feature: action.payload.outputField.feature,
                            value: action.payload.outputField.value,
                            rank: action.payload.outputField.rank,
                            rankOrder: action.payload.outputField.rankOrder,
                            segmentId: action.payload.outputField.segmentId,
                            isFinalResult: action.payload.outputField.isFinalResult,
                        };
                    }
                }, (pmml) => {
                    const modelIndex = action.payload.modelIndex;
                    const outputField = action.payload.outputField;
                    const outputFieldIndex = action.payload.outputIndex;
                    const miningSchema = getMiningSchema(pmml, modelIndex);
                    if (miningSchema !== undefined) {
                        validationRegistry.clear(Builder().forModel(modelIndex).forOutput().forOutputField(outputFieldIndex).forTargetField().build());
                        validateOutput(modelIndex, outputField, outputFieldIndex, miningSchema.MiningField, validationRegistry);
                    }
                });
                break;
            case Actions.UpdateDataDictionaryField:
                state.forEach((outputField, index) => {
                    if (outputField.targetField === action.payload.originalName) {
                        historyService.batch(state, Builder().forModel(action.payload.modelIndex).forOutput().forOutputField().build(), (draft) => {
                            draft[index] = {
                                ...draft[index],
                                targetField: action.payload.dataField.name,
                            };
                        });
                    }
                });
                break;
        }
        return state;
    };
};
//# sourceMappingURL=OutputFieldReducer.js.map