import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useEffect, useState } from "react";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Text, TextContent, TextVariants } from "@patternfly/react-core/dist/js/components/Text";
import { Stack, StackItem } from "@patternfly/react-core/dist/js/layouts/Stack";
import { ActionGroup, Form, FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { TextArea } from "@patternfly/react-core/dist/js/components/TextArea";
import "./OutputsBatchAdd.scss";
const OutputsBatchAdd = ({ onAdd, onCancel }) => {
    const [input, setInput] = useState("");
    const [inputValidation, setInputValidation] = useState("default");
    useEffect(() => {
        var _a;
        (_a = document.querySelector(`#outputs`)) === null || _a === void 0 ? void 0 : _a.focus();
    }, []);
    const handleInputChange = (value) => {
        setInput(value);
    };
    const validateInput = () => {
        const validation = input.trim().length > 0 ? "success" : "error";
        setInputValidation(validation);
        return validation;
    };
    const handleSubmit = (event) => {
        if (validateInput() === "success") {
            onAdd(input);
        }
        event.preventDefault();
    };
    return (_jsx("section", { children: _jsxs(Stack, { hasGutter: true, children: [_jsx(StackItem, { children: _jsxs(TextContent, { children: [_jsx(Text, { component: TextVariants.h3, children: "Add Multiple Output Fields" }), _jsxs(Text, { component: TextVariants.p, children: ["You can add multiple outputs by entering their names below. Add them one per line.", _jsx("br", {}), "They will be created with the default type of ", _jsx("em", { children: "String" }), ". You will be able to edit them later."] })] }) }), _jsx(StackItem, { children: _jsxs(Form, { onSubmit: handleSubmit, style: { gridGap: 0 }, children: [_jsx(FormGroup, { label: "Outputs", fieldId: "outputs", isRequired: true, validated: inputValidation, helperTextInvalid: "Please enter at least one Output name", children: _jsx(TextArea, { className: "outputs-container__multiple-outputs", value: input, onChange: handleInputChange, name: "outputs", isRequired: true, id: "outputs", placeholder: "First Output\nSecond Output\n..." }) }), _jsxs(ActionGroup, { children: [_jsx(Button, { variant: "primary", type: "submit", children: "Add Them" }), _jsx(Button, { variant: "link", onClick: () => onCancel(), children: "Never mind" })] })] }) })] }) }));
};
export default OutputsBatchAdd;
//# sourceMappingURL=OutputsBatchAdd.js.map