import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useEffect, useMemo, useState } from "react";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { Stack, StackItem } from "@patternfly/react-core/dist/js/layouts/Stack";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import { Form, FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { Title, TitleSizes } from "@patternfly/react-core/dist/js/components/Title";
import { ArrowAltCircleLeftIcon } from "@patternfly/react-icons/dist/js/icons/arrow-alt-circle-left-icon";
import { HelpIcon } from "@patternfly/react-icons/dist/js/icons/help-icon";
import { GenericSelector } from "../../EditorScorecard/atoms";
import "./MiningSchemaPropertiesEdit.scss";
import { useValidationRegistry } from "../../../validation";
import { Builder } from "../../../paths";
import { areLowHighValuesRequired, isInvalidValueReplacementRequired, isMissingValueReplacementRequired, } from "../../../validation/MiningSchema";
const MiningSchemaPropertiesEdit = ({ modelIndex, miningFieldIndex, field, onSave, onClose, }) => {
    var _a, _b, _c, _d, _e, _f, _g;
    const [usageType, setUsageType] = useState((_a = field.usageType) !== null && _a !== void 0 ? _a : "");
    const [opType, setOpType] = useState((_b = field.optype) !== null && _b !== void 0 ? _b : "");
    const [importance, setImportance] = useState(field.importance);
    const [outliers, setOutliers] = useState((_c = field.outliers) !== null && _c !== void 0 ? _c : "");
    const [lowValue, setLowValue] = useState(field.lowValue);
    const [highValue, setHighValue] = useState(field.highValue);
    const [missingValueReplacement, setMissingValueReplacement] = useState((_d = field.missingValueReplacement) !== null && _d !== void 0 ? _d : "");
    const [missingValueTreatment, setMissingValueTreatment] = useState((_e = field.missingValueTreatment) !== null && _e !== void 0 ? _e : "");
    const [invalidValueTreatment, setInvalidValueTreatment] = useState((_f = field.invalidValueTreatment) !== null && _f !== void 0 ? _f : "");
    const [invalidValueReplacement, setInvalidValueReplacement] = useState((_g = field.invalidValueReplacement) !== null && _g !== void 0 ? _g : "");
    const [submitChanges, setSubmitChanges] = useState(false);
    const handleSave = () => {
        const updatedField = { name: field.name };
        if (usageType.length > 0) {
            updatedField.usageType = usageType;
        }
        if (opType.length > 0) {
            updatedField.optype = opType;
        }
        if (typeof importance === "number") {
            updatedField.importance = importance;
        }
        if (outliers) {
            updatedField.outliers = outliers;
        }
        if (typeof lowValue === "number") {
            updatedField.lowValue = lowValue;
        }
        if (typeof highValue === "number") {
            updatedField.highValue = highValue;
        }
        if (missingValueReplacement) {
            updatedField.missingValueReplacement = missingValueReplacement;
        }
        if (missingValueTreatment.length > 0) {
            updatedField.missingValueTreatment = missingValueTreatment;
        }
        if (invalidValueReplacement) {
            updatedField.invalidValueReplacement = invalidValueReplacement;
        }
        if (invalidValueTreatment.length > 0) {
            updatedField.invalidValueTreatment = invalidValueTreatment;
        }
        onSave(updatedField);
        setSubmitChanges(false);
    };
    useEffect(() => {
        if (submitChanges) {
            handleSave();
        }
    }, [submitChanges]);
    useEffect(() => {
        var _a, _b, _c, _d, _e, _f, _g;
        setUsageType((_a = field.usageType) !== null && _a !== void 0 ? _a : "");
        setOpType((_b = field.optype) !== null && _b !== void 0 ? _b : "");
        setImportance(field.importance);
        setOutliers((_c = field.outliers) !== null && _c !== void 0 ? _c : "");
        setLowValue(field.lowValue);
        setHighValue(field.highValue);
        setMissingValueReplacement((_d = field.missingValueReplacement) !== null && _d !== void 0 ? _d : "");
        setMissingValueTreatment((_e = field.missingValueTreatment) !== null && _e !== void 0 ? _e : "");
        setInvalidValueTreatment((_f = field.invalidValueTreatment) !== null && _f !== void 0 ? _f : "");
        setInvalidValueReplacement((_g = field.invalidValueReplacement) !== null && _g !== void 0 ? _g : "");
    }, [field]);
    const { validationRegistry } = useValidationRegistry();
    const validationsImportance = useMemo(() => validationRegistry.get(Builder().forModel(modelIndex).forMiningSchema().forMiningField(miningFieldIndex).forImportance().build()), [modelIndex, miningFieldIndex, field]);
    const validationsLowValue = useMemo(() => validationRegistry.get(Builder().forModel(modelIndex).forMiningSchema().forMiningField(miningFieldIndex).forLowValue().build()), [modelIndex, miningFieldIndex, field]);
    const validationsHighValue = useMemo(() => validationRegistry.get(Builder().forModel(modelIndex).forMiningSchema().forMiningField(miningFieldIndex).forHighValue().build()), [modelIndex, miningFieldIndex, field]);
    const validationsMissingValueReplacement = useMemo(() => validationRegistry.get(Builder()
        .forModel(modelIndex)
        .forMiningSchema()
        .forMiningField(miningFieldIndex)
        .forMissingValueReplacement()
        .build()), [modelIndex, miningFieldIndex, field]);
    const validationsInvalidValueReplacement = useMemo(() => validationRegistry.get(Builder()
        .forModel(modelIndex)
        .forMiningSchema()
        .forMiningField(miningFieldIndex)
        .forInvalidValueReplacement()
        .build()), [modelIndex, miningFieldIndex, field]);
    const enableLowValueComponent = useMemo(() => areLowHighValuesRequired(field.outliers) || field.lowValue !== undefined, [modelIndex, miningFieldIndex, field]);
    const enableHighValueComponent = useMemo(() => areLowHighValuesRequired(field.outliers) || field.highValue !== undefined, [modelIndex, miningFieldIndex, field]);
    const enableMissingValueComponent = useMemo(() => isMissingValueReplacementRequired(field.missingValueTreatment) || field.missingValueReplacement !== undefined, [modelIndex, miningFieldIndex, field]);
    const enableInvalidValueComponent = useMemo(() => isInvalidValueReplacementRequired(field.invalidValueTreatment) || field.invalidValueReplacement !== undefined, [modelIndex, miningFieldIndex, field]);
    const toNumberOrUndefined = (value) => {
        const _value = Number.parseFloat(value);
        return isNaN(_value) ? undefined : _value;
    };
    return (_jsxs(Stack, { hasGutter: true, className: "mining-schema__edit", children: [_jsx(StackItem, { children: _jsxs(Title, { headingLevel: "h4", size: TitleSizes.xl, children: [_jsx(Button, { variant: "link", isInline: true, onClick: onClose, children: field.name }), "\u00A0/\u00A0Properties"] }) }), _jsxs(StackItem, { children: [_jsx("section", { className: "mining-schema__edit__form", children: _jsx(Form, { children: _jsxs(Stack, { hasGutter: true, children: [_jsx(StackItem, { children: _jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { children: _jsx(FormGroup, { className: "mining-schema__properties__field", label: "Field Usage Type", fieldId: "usageType", children: _jsx(GenericSelector, { id: "usageType", items: [
                                                                "",
                                                                "active",
                                                                "predicted",
                                                                "target",
                                                                "supplementary",
                                                                "group",
                                                                "order",
                                                                "frequencyWeight",
                                                                "analysisWeight",
                                                            ], onSelect: (selection) => {
                                                                setUsageType(selection);
                                                                setSubmitChanges(true);
                                                            }, selection: usageType, "data-ouia-component-id": "usage-type", "data-ouia-component-type": "option-box" }) }) }), _jsx(SplitItem, { children: _jsx(FormGroup, { className: "mining-schema__properties__field", label: "Field Op Type", fieldId: "opType", children: _jsx(GenericSelector, { id: "opType", items: ["", "categorical", "ordinal", "continuous"], onSelect: (selection) => {
                                                                setOpType(selection);
                                                                setSubmitChanges(true);
                                                            }, selection: opType }) }) })] }) }), _jsx(StackItem, { children: _jsx(FormGroup, { className: "mining-schema__properties__field", label: "Importance", fieldId: "importance", helperText: validationsImportance.length === 0 ? "" : validationsImportance[0].message, validated: validationsImportance.length === 0 ? "default" : "warning", children: _jsx(TextInput, { type: "number", min: 0, max: 1, id: "importance", name: "importance", "aria-describedby": "Importance", value: importance !== null && importance !== void 0 ? importance : "", ouiaId: "importance", "data-ouia-component-type": "double-input", validated: validationsImportance.length === 0 ? "default" : "warning", onChange: (value) => setImportance(toNumberOrUndefined(value)), onBlur: () => {
                                                    if (importance !== undefined) {
                                                        let _importance = importance;
                                                        if (_importance < 0) {
                                                            _importance = 0;
                                                            setImportance(_importance);
                                                        }
                                                        else if (_importance > 1) {
                                                            _importance = 1;
                                                            setImportance(_importance);
                                                        }
                                                    }
                                                    handleSave();
                                                } }) }) }), _jsx(StackItem, { children: _jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { children: _jsx(FormGroup, { className: "mining-schema__properties__field", label: "Outliers Treatment Method", fieldId: "outliers", children: _jsx(GenericSelector, { id: "outliers", items: ["", "asIs", "asMissingValues", "asExtremeValues"], onSelect: (selection) => {
                                                                setOutliers(selection);
                                                                setSubmitChanges(true);
                                                            }, selection: outliers, "data-ouia-component-id": "outliers" }) }) }), _jsx(SplitItem, { children: _jsx(FormGroup, { label: "Low Value", fieldId: "lowValue", className: "mining-schema__properties__field", helperText: validationsLowValue.length === 0 ? "" : validationsLowValue[0].message, validated: validationsLowValue.length === 0 ? "default" : "warning", labelIcon: _jsx(Tooltip, { content: `Low Value is required when Outliers is "asExtremeValues" or "asMissingValues"`, children: _jsx("button", { "aria-label": "More information for Low Value field", onClick: (e) => e.preventDefault(), className: "pf-c-form__group-label-help", children: _jsx(HelpIcon, { style: { color: "var(--pf-global--info-color--100)" } }) }) }), children: _jsx(TextInput, { type: "number", id: "lowValue", name: "lowValue", "aria-describedby": "Low Value", value: lowValue !== null && lowValue !== void 0 ? lowValue : "", validated: validationsLowValue.length === 0 ? "default" : "warning", isDisabled: !enableLowValueComponent, placeholder: !enableLowValueComponent ? "<Not needed>" : "", className: !enableLowValueComponent ? "mining-schema__edit__form__disabled" : "", onChange: (value) => setLowValue(toNumberOrUndefined(value)), onBlur: handleSave, ouiaId: "low-value" }) }) }), _jsx(SplitItem, { children: _jsx(FormGroup, { label: "High Value", fieldId: "highValue", className: "mining-schema__properties__field", helperText: validationsHighValue.length === 0 ? "" : validationsHighValue[0].message, validated: validationsHighValue.length === 0 ? "default" : "warning", labelIcon: _jsx(Tooltip, { content: `High Value is required when Outliers is "asExtremeValues" or "asMissingValues"`, children: _jsx("button", { "aria-label": "More information for High Value field", onClick: (e) => e.preventDefault(), className: "pf-c-form__group-label-help", children: _jsx(HelpIcon, { style: { color: "var(--pf-global--info-color--100)" } }) }) }), children: _jsx(TextInput, { type: "number", id: "highValue", name: "highValue", "aria-describedby": "High Value", value: highValue !== null && highValue !== void 0 ? highValue : "", validated: validationsHighValue.length === 0 ? "default" : "warning", isDisabled: !enableHighValueComponent, placeholder: !enableHighValueComponent ? "<Not needed>" : "", className: !enableHighValueComponent ? "mining-schema__edit__form__disabled" : "", onChange: (value) => setHighValue(toNumberOrUndefined(value)), onBlur: handleSave, ouiaId: "high-value" }) }) })] }) }), _jsx(StackItem, { children: _jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { children: _jsx(FormGroup, { label: "Missing Value Treatment Method", fieldId: "missingValueTreatment", children: _jsx(GenericSelector, { id: "missingValueTreatment", items: ["", "asIs", "asMean", "asMode", "asMedian", "asValue", "returnInvalid"], onSelect: (selection) => {
                                                                setMissingValueTreatment(selection);
                                                                setSubmitChanges(true);
                                                            }, selection: missingValueTreatment }) }) }), _jsx(SplitItem, { children: _jsx(FormGroup, { label: "Missing Value Replacement", fieldId: "missingValueReplacement", validated: validationsMissingValueReplacement.length === 0 ? "default" : "warning", helperText: validationsMissingValueReplacement[0] ? validationsMissingValueReplacement[0].message : "", labelIcon: _jsx(Tooltip, { content: `Missing Value Replacement is required when Missing Value Treatment is "asMean", "asMedian" or "asMode"`, children: _jsx("button", { "aria-label": "More information for Missing Value Replacement field", onClick: (e) => e.preventDefault(), className: "pf-c-form__group-label-help", children: _jsx(HelpIcon, { style: { color: "var(--pf-global--info-color--100)" } }) }) }), children: _jsx(TextInput, { type: "text", id: "missingValueReplacement", name: "missingValueReplacement", "aria-describedby": "Missing Value Replacement", value: missingValueReplacement, validated: validationsMissingValueReplacement.length === 0 ? "default" : "warning", isDisabled: !enableMissingValueComponent, placeholder: !enableMissingValueComponent ? "<Not needed>" : "", className: !enableMissingValueComponent ? "mining-schema__edit__form__disabled" : "", onChange: (value) => setMissingValueReplacement(value), onBlur: handleSave }) }) })] }) }), _jsx(StackItem, { children: _jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { children: _jsx(FormGroup, { label: "Invalid Value Treatment Method", fieldId: "invalidValueTreatment", children: _jsx(GenericSelector, { id: "invalidValueTreatment", items: ["", "returnInvalid", "asIs", "asMissing", "asValue"], onSelect: (selection) => {
                                                                setInvalidValueTreatment(selection);
                                                                setSubmitChanges(true);
                                                            }, selection: invalidValueTreatment }) }) }), _jsx(SplitItem, { children: _jsx(FormGroup, { label: "Invalid Value Replacement", fieldId: "invalidValueReplacement", validated: validationsInvalidValueReplacement.length === 0 ? "default" : "warning", helperText: validationsInvalidValueReplacement[0] ? validationsInvalidValueReplacement[0].message : "", labelIcon: _jsx(Tooltip, { content: `Invalid Value Replacement is required when Invalid Value Treatment is "asValue"`, children: _jsx("button", { "aria-label": "More information for Invalid Value Replacement field", onClick: (e) => e.preventDefault(), className: "pf-c-form__group-label-help", children: _jsx(HelpIcon, { style: { color: "var(--pf-global--info-color--100)" } }) }) }), children: _jsx(TextInput, { type: "text", id: "invalidValueReplacement", name: "invalidValueReplacement", "aria-describedby": "Invalid Value Replacement", value: invalidValueReplacement, validated: validationsInvalidValueReplacement.length === 0 ? "default" : "warning", isDisabled: !enableInvalidValueComponent, placeholder: !enableInvalidValueComponent ? "<Not needed>" : "", className: !enableInvalidValueComponent ? "mining-schema__edit__form__disabled" : "", onChange: (value) => setInvalidValueReplacement(value), onBlur: handleSave }) }) })] }) })] }) }) }), _jsx("section", { className: "mining-schema__edit__actions", children: _jsx(Button, { variant: "primary", onClick: onClose, icon: _jsx(ArrowAltCircleLeftIcon, {}), iconPosition: "left", ouiaId: "back-to-ms-overview", children: "Back" }) })] })] }));
};
export default MiningSchemaPropertiesEdit;
//# sourceMappingURL=MiningSchemaPropertiesEdit.js.map