var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import React, { useEffect, useState } from "react";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import FormsListToolbar from "../FormsListToolbar/FormsListToolbar";
import FormsTable from "../FormsTable/FormsTable";
import FormsGallery from "../FormsGallery/FormsGallery";
import { BarsIcon, ThIcon } from "@patternfly/react-icons/dist/js/icons";
import { ServerErrors } from "@kie-tools/runtime-tools-components/dist/components/ServerErrors";
import { ToggleGroup, ToggleGroupItem, } from "@patternfly/react-core/dist/js/components/ToggleGroup";
import { Divider } from "@patternfly/react-core/dist/js/components/Divider";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
const FormsList = ({ isEnvelopeConnectedToChannel, driver, ouiaId, ouiaSafe, }) => {
    const [filterFormNames, setFilterFormNames] = useState([]);
    const [formsData, setFormsData] = useState([]);
    const [isSelected, setIsSelected] = useState({
        tableView: true,
        cardsView: false,
    });
    const [isLoading, setIsLoading] = useState(true);
    const [error, setError] = useState(null);
    useEffect(() => {
        if (!isEnvelopeConnectedToChannel) {
            setIsLoading(true);
            return;
        }
        init();
    }, [isEnvelopeConnectedToChannel]);
    const init = () => __awaiter(void 0, void 0, void 0, function* () {
        try {
            const namesFilter = yield driver.getFormFilter();
            setFilterFormNames(namesFilter.formNames);
            setIsLoading(true);
            const response = yield driver.getFormsQuery();
            setFormsData(response);
            setIsLoading(false);
        }
        catch (errorResponse) {
            setError(errorResponse);
        }
    });
    const applyFilter = (filters) => {
        driver.applyFilter(filters);
        init();
    };
    const handleItemClick = (_isChosen, event) => {
        const toggleButtonId = event.currentTarget.id;
        if (toggleButtonId === "tableView") {
            setIsSelected({
                tableView: true,
                cardsView: false,
            });
        }
        else if (toggleButtonId === "cardsView") {
            setIsSelected({
                tableView: false,
                cardsView: true,
            });
        }
    };
    if (error) {
        return React.createElement(ServerErrors, { error: error, variant: "large" });
    }
    return (React.createElement("div", Object.assign({}, componentOuiaProps(ouiaId, "forms-list", ouiaSafe)),
        React.createElement(Split, { hasGutter: true },
            React.createElement(SplitItem, null,
                React.createElement(FormsListToolbar, { applyFilter: applyFilter, setFilterFormNames: setFilterFormNames, filterFormNames: filterFormNames })),
            React.createElement(SplitItem, { isFilled: true }),
            React.createElement(SplitItem, { style: { padding: "20px" } },
                React.createElement(ToggleGroup, { "aria-label": "switch view toggle group" },
                    React.createElement(ToggleGroupItem, { icon: React.createElement(BarsIcon, null), "aria-label": "table view icon button", buttonId: "tableView", isSelected: isSelected.tableView, onChange: handleItemClick }),
                    React.createElement(ToggleGroupItem, { icon: React.createElement(ThIcon, null), "aria-label": "card view icon button", buttonId: "cardsView", isSelected: isSelected.cardsView, onChange: handleItemClick })))),
        React.createElement(Divider, null),
        isSelected.tableView ? (React.createElement(FormsTable, { driver: driver, formsData: formsData, setFormsData: setFormsData, isLoading: isLoading })) : (React.createElement(FormsGallery, { formsData: formsData, driver: driver, isLoading: isLoading }))));
};
export default FormsList;
//# sourceMappingURL=FormsList.js.map