import React, { useEffect } from "react";
import { v4 as uuidv4 } from "uuid";
import { transform } from "@babel/standalone";
import ReactDOM from "react-dom";
import * as Patternfly from "@patternfly/react-core/dist/js";
import { sourceHandler } from "../../../utils";
import ResourcesContainer from "../ResourcesContainer/ResourcesContainer";
import "@patternfly/patternfly/patternfly.css";
const ReactFormRenderer = ({ source, resources, setIsExecuting }) => {
    useEffect(() => {
        if (source) {
            renderform();
        }
    }, [source, resources]);
    const renderform = () => {
        if (source) {
            setIsExecuting(true);
            try {
                window.React = React;
                window.ReactDOM = ReactDOM;
                window.PatternFlyReact = Patternfly;
                const container = document.getElementById("formContainer");
                if (!container) {
                    return;
                }
                container.innerHTML = "";
                const containerId = uuidv4();
                const formContainer = document.createElement("div");
                formContainer.id = containerId;
                container.appendChild(formContainer);
                const { reactElements, patternflyElements, formName, trimmedSource } = sourceHandler(source);
                const content = `
        const {${reactElements}} = React;
        const {${patternflyElements}} = PatternFlyReact;
        ${trimmedSource}
        const target = document.getElementById("${containerId}");
        const element = window.React.createElement(${formName}, {});
        window.ReactDOM.render(element, target);
        `;
                const reactCode = transform(content.trim(), {
                    presets: [
                        "react",
                        [
                            "typescript",
                            {
                                allExtensions: true,
                                isTSX: true,
                            },
                        ],
                    ],
                }).code;
                const scriptElement = document.createElement("script");
                scriptElement.type = "module";
                scriptElement.text = reactCode;
                container.appendChild(scriptElement);
            }
            finally {
                setIsExecuting(false);
            }
        }
    };
    return (React.createElement(React.Fragment, null,
        React.createElement("div", null,
            React.createElement(ResourcesContainer, { resources: resources }),
            React.createElement("div", { style: {
                    height: "100%",
                }, id: "formContainer" }))));
};
export default ReactFormRenderer;
//# sourceMappingURL=ReactFormRenderer.js.map