import React, { useImperativeHandle, useState } from "react";
import CustomDashboardView from "./components/CustomDashboardView/CustomDashboardView";
import CustomDashboardViewEnvelopeViewDriver from "./CustomDashboardViewEnvelopeViewDriver";
import "@patternfly/patternfly/patternfly.css";
export const CustomDashboardViewEnvelopeView = React.forwardRef((props, forwardedRef) => {
    const [isEnvelopeConnectedToChannel, setEnvelopeConnectedToChannel] = useState(false);
    const [customDashboardName, setCustomDashboardName] = useState();
    const [targetOrigin, setTargetOrigin] = useState();
    useImperativeHandle(forwardedRef, () => ({
        initialize: (dashboardName, targetOrigin) => {
            setEnvelopeConnectedToChannel(true);
            setCustomDashboardName(dashboardName);
            setTargetOrigin(targetOrigin);
        },
    }), []);
    return (React.createElement(React.Fragment, null, customDashboardName && customDashboardName != "undefined" && (React.createElement(CustomDashboardView, { isEnvelopeConnectedToChannel: isEnvelopeConnectedToChannel, driver: new CustomDashboardViewEnvelopeViewDriver(props.channelApi), customDashboardName: customDashboardName, targetOrigin: targetOrigin }))));
});
export default CustomDashboardViewEnvelopeView;
//# sourceMappingURL=CustomDashboardViewEnvelopeView.js.map