import { NotificationSeverity } from "@kie-tools-core/notifications/dist/api";
export declare enum DmnEvaluationStatus {
    SUCCEEDED = "SUCCEEDED",
    SKIPPED = "SKIPPED",
    FAILED = "FAILED"
}
export interface DmnEvaluationMessages {
    severity: NotificationSeverity;
    message: string;
    messageType: string;
    sourceId: string;
    level: string;
}
export declare type DmnEvaluationResult = boolean | number | null | Record<string, any> | Record<string, any>[] | string | DmnEvaluationResult[];
export interface DecisionResult {
    decisionId: string;
    decisionName: string;
    result: DmnEvaluationResult;
    messages?: DmnEvaluationMessages[];
    evaluationStatus: DmnEvaluationStatus;
}
export interface ExtendedServicesDmnResult {
    decisionResults?: DecisionResult[];
    dmnContext?: Record<string, any>;
    messages: DmnEvaluationMessages[];
    namespace?: string;
}
//# sourceMappingURL=dmnResult.d.ts.map